@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user-assigned identities. The type 'None' will remove any identity.
 */
public enum class IdentityType(
    public val javaValue: com.pulumi.azurenative.eventgrid.enums.IdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.enums.IdentityType> {
    None(com.pulumi.azurenative.eventgrid.enums.IdentityType.None),
    SystemAssigned(com.pulumi.azurenative.eventgrid.enums.IdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.eventgrid.enums.IdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.eventgrid.enums.IdentityType.SystemAssigned_UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.eventgrid.enums.IdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.enums.IdentityType): IdentityType =
            IdentityType.values().first { it.javaValue == javaType }
    }
}
