@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This determines if events published to this partner namespace should use the source attribute in the event payload
 * or use the channel name in the header when matching to the partner topic. If none is specified, source attribute routing will be used to match the partner topic.
 */
public enum class PartnerTopicRoutingMode(
    public val javaValue: com.pulumi.azurenative.eventgrid.enums.PartnerTopicRoutingMode,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.enums.PartnerTopicRoutingMode> {
    SourceEventAttribute(com.pulumi.azurenative.eventgrid.enums.PartnerTopicRoutingMode.SourceEventAttribute),
    ChannelNameHeader(com.pulumi.azurenative.eventgrid.enums.PartnerTopicRoutingMode.ChannelNameHeader),
    ;

    override fun toJava(): com.pulumi.azurenative.eventgrid.enums.PartnerTopicRoutingMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.enums.PartnerTopicRoutingMode):
            PartnerTopicRoutingMode =
            PartnerTopicRoutingMode.values().first { it.javaValue == javaType }
    }
}
