@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.AzureFunctionEventSubscriptionDestinationArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Information about the azure function destination for an event subscription.
 * @property deliveryAttributeMappings Delivery attribute details.
 * @property endpointType Type of the endpoint for the event subscription destination.
 * Expected value is 'AzureFunction'.
 * @property maxEventsPerBatch Maximum number of events per batch.
 * @property preferredBatchSizeInKilobytes Preferred batch size in Kilobytes.
 * @property resourceId The Azure Resource Id that represents the endpoint of the Azure Function destination of an event subscription.
 */
public data class AzureFunctionEventSubscriptionDestinationArgs(
    public val deliveryAttributeMappings:
    Output<List<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>>? =
        null,
    public val endpointType: Output<String>,
    public val maxEventsPerBatch: Output<Int>? = null,
    public val preferredBatchSizeInKilobytes: Output<Int>? = null,
    public val resourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.AzureFunctionEventSubscriptionDestinationArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventgrid.inputs.AzureFunctionEventSubscriptionDestinationArgs =
        com.pulumi.azurenative.eventgrid.inputs.AzureFunctionEventSubscriptionDestinationArgs.builder()
            .deliveryAttributeMappings(
                deliveryAttributeMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            )
            .endpointType(endpointType.applyValue({ args0 -> args0 }))
            .maxEventsPerBatch(maxEventsPerBatch?.applyValue({ args0 -> args0 }))
            .preferredBatchSizeInKilobytes(preferredBatchSizeInKilobytes?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFunctionEventSubscriptionDestinationArgs].
 */
@PulumiTagMarker
public class AzureFunctionEventSubscriptionDestinationArgsBuilder internal constructor() {
    private var deliveryAttributeMappings:
        Output<List<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>>? =
        null

    private var endpointType: Output<String>? = null

    private var maxEventsPerBatch: Output<Int>? = null

    private var preferredBatchSizeInKilobytes: Output<Int>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Delivery attribute details.
     */
    @JvmName("vicubwvstkksyllu")
    public suspend
    fun deliveryAttributeMappings(`value`: Output<List<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>>) {
        this.deliveryAttributeMappings = value
    }

    @JvmName("punprktdiexbsjts")
    public suspend fun deliveryAttributeMappings(
        vararg
        values: Output<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>,
    ) {
        this.deliveryAttributeMappings = Output.all(values.asList())
    }

    /**
     * @param values Delivery attribute details.
     */
    @JvmName("ugqdwfxpbyhdrofw")
    public suspend
    fun deliveryAttributeMappings(values: List<Output<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>>) {
        this.deliveryAttributeMappings = Output.all(values)
    }

    /**
     * @param value Type of the endpoint for the event subscription destination.
     * Expected value is 'AzureFunction'.
     */
    @JvmName("gdqqpqbbtfblqkak")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value Maximum number of events per batch.
     */
    @JvmName("rsvoynilwsandlyx")
    public suspend fun maxEventsPerBatch(`value`: Output<Int>) {
        this.maxEventsPerBatch = value
    }

    /**
     * @param value Preferred batch size in Kilobytes.
     */
    @JvmName("naxpxevlwofogogs")
    public suspend fun preferredBatchSizeInKilobytes(`value`: Output<Int>) {
        this.preferredBatchSizeInKilobytes = value
    }

    /**
     * @param value The Azure Resource Id that represents the endpoint of the Azure Function destination of an event subscription.
     */
    @JvmName("efnxqinwkbhwarpf")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Delivery attribute details.
     */
    @JvmName("innvaoeptvtvhtaj")
    public suspend
    fun deliveryAttributeMappings(`value`: List<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryAttributeMappings = mapped
    }

    /**
     * @param values Delivery attribute details.
     */
    @JvmName("lxbltvkeopidcwig")
    public suspend fun deliveryAttributeMappings(
        vararg
        values: Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deliveryAttributeMappings = mapped
    }

    /**
     * @param value Type of the endpoint for the event subscription destination.
     * Expected value is 'AzureFunction'.
     */
    @JvmName("tavfwwgjrjjdhupr")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value Maximum number of events per batch.
     */
    @JvmName("nduvkvsmswphcill")
    public suspend fun maxEventsPerBatch(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxEventsPerBatch = mapped
    }

    /**
     * @param value Preferred batch size in Kilobytes.
     */
    @JvmName("akrqxvlfffrvnqcj")
    public suspend fun preferredBatchSizeInKilobytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBatchSizeInKilobytes = mapped
    }

    /**
     * @param value The Azure Resource Id that represents the endpoint of the Azure Function destination of an event subscription.
     */
    @JvmName("jdutygtetiyjflws")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): AzureFunctionEventSubscriptionDestinationArgs =
        AzureFunctionEventSubscriptionDestinationArgs(
            deliveryAttributeMappings = deliveryAttributeMappings,
            endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
            maxEventsPerBatch = maxEventsPerBatch,
            preferredBatchSizeInKilobytes = preferredBatchSizeInKilobytes,
            resourceId = resourceId,
        )
}
