@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.ClientCertificateSubjectDistinguishedNameArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * CA certificate subject distinguished name information used by service to authenticate clients.
 * For more information, see https://docs.microsoft.com/en-us/dotnet/api/system.security.cryptography.x509certificates.x500distinguishedname?view=net-6.0#remarks
 * @property commonName The common name field in the subject name. The allowed limit is 64 characters and it should be specified.
 * @property countryCode The country code field in the subject name. If present, the country code should be represented by two-letter code defined in ISO 2166-1 (alpha-2). For example: 'US'.
 * @property organization The organization field in the subject name. If present, the allowed limit is 64 characters.
 * @property organizationUnit The organization unit field in the subject name. If present, the allowed limit is 32 characters.
 */
public data class ClientCertificateSubjectDistinguishedNameArgs(
    public val commonName: Output<String>? = null,
    public val countryCode: Output<String>? = null,
    public val organization: Output<String>? = null,
    public val organizationUnit: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.ClientCertificateSubjectDistinguishedNameArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventgrid.inputs.ClientCertificateSubjectDistinguishedNameArgs =
        com.pulumi.azurenative.eventgrid.inputs.ClientCertificateSubjectDistinguishedNameArgs.builder()
            .commonName(commonName?.applyValue({ args0 -> args0 }))
            .countryCode(countryCode?.applyValue({ args0 -> args0 }))
            .organization(organization?.applyValue({ args0 -> args0 }))
            .organizationUnit(organizationUnit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClientCertificateSubjectDistinguishedNameArgs].
 */
@PulumiTagMarker
public class ClientCertificateSubjectDistinguishedNameArgsBuilder internal constructor() {
    private var commonName: Output<String>? = null

    private var countryCode: Output<String>? = null

    private var organization: Output<String>? = null

    private var organizationUnit: Output<String>? = null

    /**
     * @param value The common name field in the subject name. The allowed limit is 64 characters and it should be specified.
     */
    @JvmName("pbpgefxkmewnashm")
    public suspend fun commonName(`value`: Output<String>) {
        this.commonName = value
    }

    /**
     * @param value The country code field in the subject name. If present, the country code should be represented by two-letter code defined in ISO 2166-1 (alpha-2). For example: 'US'.
     */
    @JvmName("lrjrsiamwcifxmtv")
    public suspend fun countryCode(`value`: Output<String>) {
        this.countryCode = value
    }

    /**
     * @param value The organization field in the subject name. If present, the allowed limit is 64 characters.
     */
    @JvmName("twsjpoiyeltlhlnw")
    public suspend fun organization(`value`: Output<String>) {
        this.organization = value
    }

    /**
     * @param value The organization unit field in the subject name. If present, the allowed limit is 32 characters.
     */
    @JvmName("nidlyrtwpjbdwgis")
    public suspend fun organizationUnit(`value`: Output<String>) {
        this.organizationUnit = value
    }

    /**
     * @param value The common name field in the subject name. The allowed limit is 64 characters and it should be specified.
     */
    @JvmName("fopiianeilsywxfm")
    public suspend fun commonName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commonName = mapped
    }

    /**
     * @param value The country code field in the subject name. If present, the country code should be represented by two-letter code defined in ISO 2166-1 (alpha-2). For example: 'US'.
     */
    @JvmName("siviqoocccopfnan")
    public suspend fun countryCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.countryCode = mapped
    }

    /**
     * @param value The organization field in the subject name. If present, the allowed limit is 64 characters.
     */
    @JvmName("ryomqxxgrlpxjtef")
    public suspend fun organization(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organization = mapped
    }

    /**
     * @param value The organization unit field in the subject name. If present, the allowed limit is 32 characters.
     */
    @JvmName("mdrknqcvfmhvnbrv")
    public suspend fun organizationUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationUnit = mapped
    }

    internal fun build(): ClientCertificateSubjectDistinguishedNameArgs =
        ClientCertificateSubjectDistinguishedNameArgs(
            commonName = commonName,
            countryCode = countryCode,
            organization = organization,
            organizationUnit = organizationUnit,
        )
}
