@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.ClientCertificateThumbprintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Thumbprints are used by the service to validate the device permission when authentication is done using self signed certificate.
 * @property primary The primary thumbprint used for validation.
 * @property secondary The secondary thumbprint used for validation.
 */
public data class ClientCertificateThumbprintArgs(
    public val primary: Output<String>? = null,
    public val secondary: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.ClientCertificateThumbprintArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.ClientCertificateThumbprintArgs =
        com.pulumi.azurenative.eventgrid.inputs.ClientCertificateThumbprintArgs.builder()
            .primary(primary?.applyValue({ args0 -> args0 }))
            .secondary(secondary?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClientCertificateThumbprintArgs].
 */
@PulumiTagMarker
public class ClientCertificateThumbprintArgsBuilder internal constructor() {
    private var primary: Output<String>? = null

    private var secondary: Output<String>? = null

    /**
     * @param value The primary thumbprint used for validation.
     */
    @JvmName("krnwlmoodlqpaxuy")
    public suspend fun primary(`value`: Output<String>) {
        this.primary = value
    }

    /**
     * @param value The secondary thumbprint used for validation.
     */
    @JvmName("ajxgcaeopcghdqnk")
    public suspend fun secondary(`value`: Output<String>) {
        this.secondary = value
    }

    /**
     * @param value The primary thumbprint used for validation.
     */
    @JvmName("dfttuyfpdjjqqluo")
    public suspend fun primary(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    /**
     * @param value The secondary thumbprint used for validation.
     */
    @JvmName("cdodynvsfvmciahn")
    public suspend fun secondary(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondary = mapped
    }

    internal fun build(): ClientCertificateThumbprintArgs = ClientCertificateThumbprintArgs(
        primary = primary,
        secondary = secondary,
    )
}
