@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetClientGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientGroupName Name of the client group.
 * @property namespaceName Name of the namespace.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetClientGroupPlainArgs(
    public val clientGroupName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetClientGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetClientGroupPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetClientGroupPlainArgs.builder()
            .clientGroupName(clientGroupName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClientGroupPlainArgs].
 */
@PulumiTagMarker
public class GetClientGroupPlainArgsBuilder internal constructor() {
    private var clientGroupName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the client group.
     */
    @JvmName("ysnqxopsjvnmomsf")
    public suspend fun clientGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clientGroupName = mapped
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("liisjbmpehudhgfu")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("cyggncyblqoaprsf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetClientGroupPlainArgs = GetClientGroupPlainArgs(
        clientGroupName = clientGroupName ?: throw PulumiNullFieldException("clientGroupName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
