@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetPartnerTopicEventSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property eventSubscriptionName Name of the event subscription to be found. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
 * @property partnerTopicName Name of the partner topic.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class GetPartnerTopicEventSubscriptionPlainArgs(
    public val eventSubscriptionName: String,
    public val partnerTopicName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetPartnerTopicEventSubscriptionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventgrid.inputs.GetPartnerTopicEventSubscriptionPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetPartnerTopicEventSubscriptionPlainArgs.builder()
            .eventSubscriptionName(eventSubscriptionName.let({ args0 -> args0 }))
            .partnerTopicName(partnerTopicName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPartnerTopicEventSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetPartnerTopicEventSubscriptionPlainArgsBuilder internal constructor() {
    private var eventSubscriptionName: String? = null

    private var partnerTopicName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the event subscription to be found. Event subscription names must be between 3 and 100 characters in length and use alphanumeric letters only.
     */
    @JvmName("duphwqbpyrevcnur")
    public suspend fun eventSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.eventSubscriptionName = mapped
    }

    /**
     * @param value Name of the partner topic.
     */
    @JvmName("bkrabvygckyhfxro")
    public suspend fun partnerTopicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.partnerTopicName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("uiqgefhnbembgslt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPartnerTopicEventSubscriptionPlainArgs =
        GetPartnerTopicEventSubscriptionPlainArgs(
            eventSubscriptionName = eventSubscriptionName ?: throw
                PulumiNullFieldException("eventSubscriptionName"),
            partnerTopicName = partnerTopicName ?: throw PulumiNullFieldException("partnerTopicName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
