@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.GetSystemTopicPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property systemTopicName Name of the system topic.
 */
public data class GetSystemTopicPlainArgs(
    public val resourceGroupName: String,
    public val systemTopicName: String,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.GetSystemTopicPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.GetSystemTopicPlainArgs =
        com.pulumi.azurenative.eventgrid.inputs.GetSystemTopicPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .systemTopicName(systemTopicName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSystemTopicPlainArgs].
 */
@PulumiTagMarker
public class GetSystemTopicPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var systemTopicName: String? = null

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("gleaclcgyuvkjlak")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the system topic.
     */
    @JvmName("mbrxwqftixmbiimg")
    public suspend fun systemTopicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.systemTopicName = mapped
    }

    internal fun build(): GetSystemTopicPlainArgs = GetSystemTopicPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        systemTopicName = systemTopicName ?: throw PulumiNullFieldException("systemTopicName"),
    )
}
