@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.JsonFieldArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This is used to express the source of an input schema mapping for a single target field in the Event Grid Event schema. This is currently used in the mappings for the 'id', 'topic' and 'eventtime' properties. This represents a field in the input event schema.
 * @property sourceField Name of a field in the input event schema that's to be used as the source of a mapping.
 */
public data class JsonFieldArgs(
    public val sourceField: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.JsonFieldArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.JsonFieldArgs =
        com.pulumi.azurenative.eventgrid.inputs.JsonFieldArgs.builder()
            .sourceField(sourceField?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JsonFieldArgs].
 */
@PulumiTagMarker
public class JsonFieldArgsBuilder internal constructor() {
    private var sourceField: Output<String>? = null

    /**
     * @param value Name of a field in the input event schema that's to be used as the source of a mapping.
     */
    @JvmName("dplktrxttggsqofo")
    public suspend fun sourceField(`value`: Output<String>) {
        this.sourceField = value
    }

    /**
     * @param value Name of a field in the input event schema that's to be used as the source of a mapping.
     */
    @JvmName("tambdcethbuloesd")
    public suspend fun sourceField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceField = mapped
    }

    internal fun build(): JsonFieldArgs = JsonFieldArgs(
        sourceField = sourceField,
    )
}
