@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.JsonFieldWithDefaultArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This is used to express the source of an input schema mapping for a single target field
 * in the Event Grid Event schema. This is currently used in the mappings for the 'subject',
 * 'eventtype' and 'dataversion' properties. This represents a field in the input event schema
 * along with a default value to be used, and at least one of these two properties should be provided.
 * @property defaultValue The default value to be used for mapping when a SourceField is not provided or if there's no property with the specified name in the published JSON event payload.
 * @property sourceField Name of a field in the input event schema that's to be used as the source of a mapping.
 */
public data class JsonFieldWithDefaultArgs(
    public val defaultValue: Output<String>? = null,
    public val sourceField: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.JsonFieldWithDefaultArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.JsonFieldWithDefaultArgs =
        com.pulumi.azurenative.eventgrid.inputs.JsonFieldWithDefaultArgs.builder()
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 }))
            .sourceField(sourceField?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JsonFieldWithDefaultArgs].
 */
@PulumiTagMarker
public class JsonFieldWithDefaultArgsBuilder internal constructor() {
    private var defaultValue: Output<String>? = null

    private var sourceField: Output<String>? = null

    /**
     * @param value The default value to be used for mapping when a SourceField is not provided or if there's no property with the specified name in the published JSON event payload.
     */
    @JvmName("mvdpmtixvqtlgtdh")
    public suspend fun defaultValue(`value`: Output<String>) {
        this.defaultValue = value
    }

    /**
     * @param value Name of a field in the input event schema that's to be used as the source of a mapping.
     */
    @JvmName("wmacouqsqbjpjuxd")
    public suspend fun sourceField(`value`: Output<String>) {
        this.sourceField = value
    }

    /**
     * @param value The default value to be used for mapping when a SourceField is not provided or if there's no property with the specified name in the published JSON event payload.
     */
    @JvmName("omekgdmbufmhaoot")
    public suspend fun defaultValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value Name of a field in the input event schema that's to be used as the source of a mapping.
     */
    @JvmName("birmncykpotkebvf")
    public suspend fun sourceField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceField = mapped
    }

    internal fun build(): JsonFieldWithDefaultArgs = JsonFieldWithDefaultArgs(
        defaultValue = defaultValue,
        sourceField = sourceField,
    )
}
