@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.NumberLessThanAdvancedFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * NumberLessThan Advanced Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'NumberLessThan'.
 * @property value The filter value.
 */
public data class NumberLessThanAdvancedFilterArgs(
    public val key: Output<String>? = null,
    public val operatorType: Output<String>,
    public val `value`: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.NumberLessThanAdvancedFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.NumberLessThanAdvancedFilterArgs =
        com.pulumi.azurenative.eventgrid.inputs.NumberLessThanAdvancedFilterArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .operatorType(operatorType.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NumberLessThanAdvancedFilterArgs].
 */
@PulumiTagMarker
public class NumberLessThanAdvancedFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var operatorType: Output<String>? = null

    private var `value`: Output<Double>? = null

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("jkdujbjpfqqpnerw")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'NumberLessThan'.
     */
    @JvmName("qxndgyalnaqxcsns")
    public suspend fun operatorType(`value`: Output<String>) {
        this.operatorType = value
    }

    /**
     * @param value The filter value.
     */
    @JvmName("dqijxdjmgsyljwry")
    public suspend fun `value`(`value`: Output<Double>) {
        this.`value` = value
    }

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("vpkilhmdlnciaany")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'NumberLessThan'.
     */
    @JvmName("ccqwfvgmtjlsvdsv")
    public suspend fun operatorType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    /**
     * @param value The filter value.
     */
    @JvmName("xtfgrccqqxegdunx")
    public suspend fun `value`(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): NumberLessThanAdvancedFilterArgs = NumberLessThanAdvancedFilterArgs(
        key = key,
        operatorType = operatorType ?: throw PulumiNullFieldException("operatorType"),
        `value` = `value`,
    )
}
