@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.NumberNotInAdvancedFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * NumberNotIn Advanced Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'NumberNotIn'.
 * @property values The set of filter values.
 */
public data class NumberNotInAdvancedFilterArgs(
    public val key: Output<String>? = null,
    public val operatorType: Output<String>,
    public val values: Output<List<Double>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.NumberNotInAdvancedFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.NumberNotInAdvancedFilterArgs =
        com.pulumi.azurenative.eventgrid.inputs.NumberNotInAdvancedFilterArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .operatorType(operatorType.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NumberNotInAdvancedFilterArgs].
 */
@PulumiTagMarker
public class NumberNotInAdvancedFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var operatorType: Output<String>? = null

    private var values: Output<List<Double>>? = null

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("weeniaqogmkxbwhw")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'NumberNotIn'.
     */
    @JvmName("ajblqxjejcedwpfi")
    public suspend fun operatorType(`value`: Output<String>) {
        this.operatorType = value
    }

    /**
     * @param value The set of filter values.
     */
    @JvmName("uouqdbtjygmrjixy")
    public suspend fun values(`value`: Output<List<Double>>) {
        this.values = value
    }

    @JvmName("ksentupfydrevdjn")
    public suspend fun values(vararg values: Output<Double>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The set of filter values.
     */
    @JvmName("hxqfwuihcgjtgfcl")
    public suspend fun values(values: List<Output<Double>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("lmrquswydxwasyna")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'NumberNotIn'.
     */
    @JvmName("umrgmdmkbqsujiov")
    public suspend fun operatorType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    /**
     * @param value The set of filter values.
     */
    @JvmName("dhobpcisdjniuyfr")
    public suspend fun values(`value`: List<Double>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The set of filter values.
     */
    @JvmName("afcyqaekvjhlryac")
    public suspend fun values(vararg values: Double) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): NumberNotInAdvancedFilterArgs = NumberNotInAdvancedFilterArgs(
        key = key,
        operatorType = operatorType ?: throw PulumiNullFieldException("operatorType"),
        values = values,
    )
}
