@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.NumberNotInFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * NumberNotIn Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'NumberNotIn'.
 * @property values The set of filter values.
 */
public data class NumberNotInFilterArgs(
    public val key: Output<String>? = null,
    public val operatorType: Output<String>,
    public val values: Output<List<Double>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.NumberNotInFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.NumberNotInFilterArgs =
        com.pulumi.azurenative.eventgrid.inputs.NumberNotInFilterArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .operatorType(operatorType.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NumberNotInFilterArgs].
 */
@PulumiTagMarker
public class NumberNotInFilterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var operatorType: Output<String>? = null

    private var values: Output<List<Double>>? = null

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("wqutsqprapuvyttl")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'NumberNotIn'.
     */
    @JvmName("qauqefrcqyvcubml")
    public suspend fun operatorType(`value`: Output<String>) {
        this.operatorType = value
    }

    /**
     * @param value The set of filter values.
     */
    @JvmName("vsggpmjixofptdfd")
    public suspend fun values(`value`: Output<List<Double>>) {
        this.values = value
    }

    @JvmName("vsqqknpqjoqucuaa")
    public suspend fun values(vararg values: Output<Double>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The set of filter values.
     */
    @JvmName("ookqggeeqllamvoq")
    public suspend fun values(values: List<Output<Double>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The field/property in the event based on which you want to filter.
     */
    @JvmName("rjsmeellcpcuwmuy")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
     * Expected value is 'NumberNotIn'.
     */
    @JvmName("dvcymhuxoqeojemy")
    public suspend fun operatorType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatorType = mapped
    }

    /**
     * @param value The set of filter values.
     */
    @JvmName("ftvmgqlrmvdlchhn")
    public suspend fun values(`value`: List<Double>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The set of filter values.
     */
    @JvmName("klapfimbfdurlaxr")
    public suspend fun values(vararg values: Double) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): NumberNotInFilterArgs = NumberNotInFilterArgs(
        key = key,
        operatorType = operatorType ?: throw PulumiNullFieldException("operatorType"),
        values = values,
    )
}
