@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.PartnerTopicInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of the corresponding partner topic of a Channel.
 * @property azureSubscriptionId Azure subscription ID of the subscriber. The partner topic associated with the channel will be
 * created under this Azure subscription.
 * @property eventTypeInfo Event Type Information for the partner topic. This information is provided by the publisher and can be used by the
 * subscriber to view different types of events that are published.
 * @property name Name of the partner topic associated with the channel.
 * @property resourceGroupName Azure Resource Group of the subscriber. The partner topic associated with the channel will be
 * created under this resource group.
 * @property source The source information is provided by the publisher to determine the scope or context from which the events
 * are originating. This information can be used by the subscriber during the approval process of the
 * created partner topic.
 */
public data class PartnerTopicInfoArgs(
    public val azureSubscriptionId: Output<String>? = null,
    public val eventTypeInfo: Output<EventTypeInfoArgs>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.PartnerTopicInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.PartnerTopicInfoArgs =
        com.pulumi.azurenative.eventgrid.inputs.PartnerTopicInfoArgs.builder()
            .azureSubscriptionId(azureSubscriptionId?.applyValue({ args0 -> args0 }))
            .eventTypeInfo(eventTypeInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PartnerTopicInfoArgs].
 */
@PulumiTagMarker
public class PartnerTopicInfoArgsBuilder internal constructor() {
    private var azureSubscriptionId: Output<String>? = null

    private var eventTypeInfo: Output<EventTypeInfoArgs>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<String>? = null

    /**
     * @param value Azure subscription ID of the subscriber. The partner topic associated with the channel will be
     * created under this Azure subscription.
     */
    @JvmName("ofxhkgjeorsinmia")
    public suspend fun azureSubscriptionId(`value`: Output<String>) {
        this.azureSubscriptionId = value
    }

    /**
     * @param value Event Type Information for the partner topic. This information is provided by the publisher and can be used by the
     * subscriber to view different types of events that are published.
     */
    @JvmName("wqerqmapaxbapolu")
    public suspend fun eventTypeInfo(`value`: Output<EventTypeInfoArgs>) {
        this.eventTypeInfo = value
    }

    /**
     * @param value Name of the partner topic associated with the channel.
     */
    @JvmName("ssdjegefdasqbkpm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Azure Resource Group of the subscriber. The partner topic associated with the channel will be
     * created under this resource group.
     */
    @JvmName("eyysnqmcqgrabvbf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The source information is provided by the publisher to determine the scope or context from which the events
     * are originating. This information can be used by the subscriber during the approval process of the
     * created partner topic.
     */
    @JvmName("eiykqhmhaojumlvm")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Azure subscription ID of the subscriber. The partner topic associated with the channel will be
     * created under this Azure subscription.
     */
    @JvmName("thobhcjgnfqrsqpx")
    public suspend fun azureSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureSubscriptionId = mapped
    }

    /**
     * @param value Event Type Information for the partner topic. This information is provided by the publisher and can be used by the
     * subscriber to view different types of events that are published.
     */
    @JvmName("rjmvivhhqopvpyoh")
    public suspend fun eventTypeInfo(`value`: EventTypeInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventTypeInfo = mapped
    }

    /**
     * @param argument Event Type Information for the partner topic. This information is provided by the publisher and can be used by the
     * subscriber to view different types of events that are published.
     */
    @JvmName("efqxqnialqjxkwxm")
    public suspend fun eventTypeInfo(argument: suspend EventTypeInfoArgsBuilder.() -> Unit) {
        val toBeMapped = EventTypeInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.eventTypeInfo = mapped
    }

    /**
     * @param value Name of the partner topic associated with the channel.
     */
    @JvmName("wxbvvclbhfendspl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Azure Resource Group of the subscriber. The partner topic associated with the channel will be
     * created under this resource group.
     */
    @JvmName("tmcobuyhxpfexpkh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The source information is provided by the publisher to determine the scope or context from which the events
     * are originating. This information can be used by the subscriber during the approval process of the
     * created partner topic.
     */
    @JvmName("letsgtysoepxdeki")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): PartnerTopicInfoArgs = PartnerTopicInfoArgs(
        azureSubscriptionId = azureSubscriptionId,
        eventTypeInfo = eventTypeInfo,
        name = name,
        resourceGroupName = resourceGroupName,
        source = source,
    )
}
