@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.RetryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about the retry policy for an event subscription.
 * @property eventTimeToLiveInMinutes Time To Live (in minutes) for events.
 * @property maxDeliveryAttempts Maximum number of delivery retry attempts for events.
 */
public data class RetryPolicyArgs(
    public val eventTimeToLiveInMinutes: Output<Int>? = null,
    public val maxDeliveryAttempts: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.RetryPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.inputs.RetryPolicyArgs =
        com.pulumi.azurenative.eventgrid.inputs.RetryPolicyArgs.builder()
            .eventTimeToLiveInMinutes(eventTimeToLiveInMinutes?.applyValue({ args0 -> args0 }))
            .maxDeliveryAttempts(maxDeliveryAttempts?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RetryPolicyArgs].
 */
@PulumiTagMarker
public class RetryPolicyArgsBuilder internal constructor() {
    private var eventTimeToLiveInMinutes: Output<Int>? = null

    private var maxDeliveryAttempts: Output<Int>? = null

    /**
     * @param value Time To Live (in minutes) for events.
     */
    @JvmName("wlmaqreatfkxqejp")
    public suspend fun eventTimeToLiveInMinutes(`value`: Output<Int>) {
        this.eventTimeToLiveInMinutes = value
    }

    /**
     * @param value Maximum number of delivery retry attempts for events.
     */
    @JvmName("asdrkiuhhaxnnpvs")
    public suspend fun maxDeliveryAttempts(`value`: Output<Int>) {
        this.maxDeliveryAttempts = value
    }

    /**
     * @param value Time To Live (in minutes) for events.
     */
    @JvmName("tegxksnwsmvdupun")
    public suspend fun eventTimeToLiveInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventTimeToLiveInMinutes = mapped
    }

    /**
     * @param value Maximum number of delivery retry attempts for events.
     */
    @JvmName("ygmytjvmhxvjbnue")
    public suspend fun maxDeliveryAttempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDeliveryAttempts = mapped
    }

    internal fun build(): RetryPolicyArgs = RetryPolicyArgs(
        eventTimeToLiveInMinutes = eventTimeToLiveInMinutes,
        maxDeliveryAttempts = maxDeliveryAttempts,
    )
}
