@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.inputs

import com.pulumi.azurenative.eventgrid.inputs.WebHookEventSubscriptionDestinationArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Information about the webhook destination for an event subscription.
 * @property azureActiveDirectoryApplicationIdOrUri The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
 * @property azureActiveDirectoryTenantId The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
 * @property deliveryAttributeMappings Delivery attribute details.
 * @property endpointType Type of the endpoint for the event subscription destination.
 * Expected value is 'WebHook'.
 * @property endpointUrl The URL that represents the endpoint of the destination of an event subscription.
 * @property maxEventsPerBatch Maximum number of events per batch.
 * @property preferredBatchSizeInKilobytes Preferred batch size in Kilobytes.
 */
public data class WebHookEventSubscriptionDestinationArgs(
    public val azureActiveDirectoryApplicationIdOrUri: Output<String>? = null,
    public val azureActiveDirectoryTenantId: Output<String>? = null,
    public val deliveryAttributeMappings:
    Output<List<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>>? =
        null,
    public val endpointType: Output<String>,
    public val endpointUrl: Output<String>? = null,
    public val maxEventsPerBatch: Output<Int>? = null,
    public val preferredBatchSizeInKilobytes: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.eventgrid.inputs.WebHookEventSubscriptionDestinationArgs> {
    override fun toJava():
        com.pulumi.azurenative.eventgrid.inputs.WebHookEventSubscriptionDestinationArgs =
        com.pulumi.azurenative.eventgrid.inputs.WebHookEventSubscriptionDestinationArgs.builder()
            .azureActiveDirectoryApplicationIdOrUri(
                azureActiveDirectoryApplicationIdOrUri?.applyValue({ args0 ->
                    args0
                }),
            )
            .azureActiveDirectoryTenantId(azureActiveDirectoryTenantId?.applyValue({ args0 -> args0 }))
            .deliveryAttributeMappings(
                deliveryAttributeMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                            args0.let({ args0 ->
                                args0.toJava()
                            })
                        })
                    })
                }),
            )
            .endpointType(endpointType.applyValue({ args0 -> args0 }))
            .endpointUrl(endpointUrl?.applyValue({ args0 -> args0 }))
            .maxEventsPerBatch(maxEventsPerBatch?.applyValue({ args0 -> args0 }))
            .preferredBatchSizeInKilobytes(
                preferredBatchSizeInKilobytes?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [WebHookEventSubscriptionDestinationArgs].
 */
@PulumiTagMarker
public class WebHookEventSubscriptionDestinationArgsBuilder internal constructor() {
    private var azureActiveDirectoryApplicationIdOrUri: Output<String>? = null

    private var azureActiveDirectoryTenantId: Output<String>? = null

    private var deliveryAttributeMappings:
        Output<List<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>>? =
        null

    private var endpointType: Output<String>? = null

    private var endpointUrl: Output<String>? = null

    private var maxEventsPerBatch: Output<Int>? = null

    private var preferredBatchSizeInKilobytes: Output<Int>? = null

    /**
     * @param value The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
     */
    @JvmName("eeaxgvgccppdmdwl")
    public suspend fun azureActiveDirectoryApplicationIdOrUri(`value`: Output<String>) {
        this.azureActiveDirectoryApplicationIdOrUri = value
    }

    /**
     * @param value The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
     */
    @JvmName("fdoipwgqoxxjlnid")
    public suspend fun azureActiveDirectoryTenantId(`value`: Output<String>) {
        this.azureActiveDirectoryTenantId = value
    }

    /**
     * @param value Delivery attribute details.
     */
    @JvmName("wnspxucyamikdkxq")
    public suspend
    fun deliveryAttributeMappings(`value`: Output<List<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>>) {
        this.deliveryAttributeMappings = value
    }

    @JvmName("fskhvuwgqyyjksyi")
    public suspend fun deliveryAttributeMappings(
        vararg
        values: Output<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>,
    ) {
        this.deliveryAttributeMappings = Output.all(values.asList())
    }

    /**
     * @param values Delivery attribute details.
     */
    @JvmName("nwrkqkiftcnsvyvo")
    public suspend
    fun deliveryAttributeMappings(values: List<Output<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>>) {
        this.deliveryAttributeMappings = Output.all(values)
    }

    /**
     * @param value Type of the endpoint for the event subscription destination.
     * Expected value is 'WebHook'.
     */
    @JvmName("gppjwaibeumirfbl")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value The URL that represents the endpoint of the destination of an event subscription.
     */
    @JvmName("foqprudplkmntsoo")
    public suspend fun endpointUrl(`value`: Output<String>) {
        this.endpointUrl = value
    }

    /**
     * @param value Maximum number of events per batch.
     */
    @JvmName("qnyiuyhamvfophld")
    public suspend fun maxEventsPerBatch(`value`: Output<Int>) {
        this.maxEventsPerBatch = value
    }

    /**
     * @param value Preferred batch size in Kilobytes.
     */
    @JvmName("jqyeflmiigfrnjyt")
    public suspend fun preferredBatchSizeInKilobytes(`value`: Output<Int>) {
        this.preferredBatchSizeInKilobytes = value
    }

    /**
     * @param value The Azure Active Directory Application ID or URI to get the access token that will be included as the bearer token in delivery requests.
     */
    @JvmName("ivpwqwiegvbswogq")
    public suspend fun azureActiveDirectoryApplicationIdOrUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureActiveDirectoryApplicationIdOrUri = mapped
    }

    /**
     * @param value The Azure Active Directory Tenant ID to get the access token that will be included as the bearer token in delivery requests.
     */
    @JvmName("envxsmpdedqqnrhh")
    public suspend fun azureActiveDirectoryTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureActiveDirectoryTenantId = mapped
    }

    /**
     * @param value Delivery attribute details.
     */
    @JvmName("tuogyumfjegorcqk")
    public suspend
    fun deliveryAttributeMappings(`value`: List<Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryAttributeMappings = mapped
    }

    /**
     * @param values Delivery attribute details.
     */
    @JvmName("rctpvtrmxbywpjoy")
    public suspend fun deliveryAttributeMappings(
        vararg
        values: Either<DynamicDeliveryAttributeMappingArgs, StaticDeliveryAttributeMappingArgs>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deliveryAttributeMappings = mapped
    }

    /**
     * @param value Type of the endpoint for the event subscription destination.
     * Expected value is 'WebHook'.
     */
    @JvmName("stkgekycvrnnixuc")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The URL that represents the endpoint of the destination of an event subscription.
     */
    @JvmName("qhyxjnigtkcmueek")
    public suspend fun endpointUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointUrl = mapped
    }

    /**
     * @param value Maximum number of events per batch.
     */
    @JvmName("rmeusqbnaaeuhkcv")
    public suspend fun maxEventsPerBatch(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxEventsPerBatch = mapped
    }

    /**
     * @param value Preferred batch size in Kilobytes.
     */
    @JvmName("krnnwjjnsnybddge")
    public suspend fun preferredBatchSizeInKilobytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBatchSizeInKilobytes = mapped
    }

    internal fun build(): WebHookEventSubscriptionDestinationArgs =
        WebHookEventSubscriptionDestinationArgs(
            azureActiveDirectoryApplicationIdOrUri = azureActiveDirectoryApplicationIdOrUri,
            azureActiveDirectoryTenantId = azureActiveDirectoryTenantId,
            deliveryAttributeMappings = deliveryAttributeMappings,
            endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
            endpointUrl = endpointUrl,
            maxEventsPerBatch = maxEventsPerBatch,
            preferredBatchSizeInKilobytes = preferredBatchSizeInKilobytes,
        )
}
