@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Information about the azure function destination for an event subscription.
 * @property deliveryAttributeMappings Delivery attribute details.
 * @property endpointType Type of the endpoint for the event subscription destination.
 * Expected value is 'AzureFunction'.
 * @property maxEventsPerBatch Maximum number of events per batch.
 * @property preferredBatchSizeInKilobytes Preferred batch size in Kilobytes.
 * @property resourceId The Azure Resource Id that represents the endpoint of the Azure Function destination of an event subscription.
 */
public data class AzureFunctionEventSubscriptionDestinationResponse(
    public val deliveryAttributeMappings:
    List<Either<DynamicDeliveryAttributeMappingResponse, StaticDeliveryAttributeMappingResponse>>? =
        null,
    public val endpointType: String,
    public val maxEventsPerBatch: Int? = null,
    public val preferredBatchSizeInKilobytes: Int? = null,
    public val resourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.AzureFunctionEventSubscriptionDestinationResponse):
            AzureFunctionEventSubscriptionDestinationResponse =
            AzureFunctionEventSubscriptionDestinationResponse(
                deliveryAttributeMappings = javaType.deliveryAttributeMappings().map({ args0 ->
                    args0.transform(
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.eventgrid.kotlin.outputs.DynamicDeliveryAttributeMappingResponse.Companion.toKotlin(args0)
                            })
                        },
                        { args0 ->
                            args0.let({ args0 ->
                                com.pulumi.azurenative.eventgrid.kotlin.outputs.StaticDeliveryAttributeMappingResponse.Companion.toKotlin(args0)
                            })
                        },
                    )
                }),
                endpointType = javaType.endpointType(),
                maxEventsPerBatch = javaType.maxEventsPerBatch().map({ args0 -> args0 }).orElse(null),
                preferredBatchSizeInKilobytes = javaType.preferredBatchSizeInKilobytes().map({ args0 ->
                    args0
                }).orElse(null),
                resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
