@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Client authentication settings for namespace resource.
 * @property alternativeAuthenticationNameSources Alternative authentication name sources related to client authentication settings for namespace resource.
 */
public data class ClientAuthenticationSettingsResponse(
    public val alternativeAuthenticationNameSources: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.ClientAuthenticationSettingsResponse):
            ClientAuthenticationSettingsResponse = ClientAuthenticationSettingsResponse(
            alternativeAuthenticationNameSources = javaType.alternativeAuthenticationNameSources().map({ args0 ->
                args0
            }),
        )
    }
}
