@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * CA certificate subject distinguished name information used by service to authenticate clients.
 * For more information, see https://docs.microsoft.com/en-us/dotnet/api/system.security.cryptography.x509certificates.x500distinguishedname?view=net-6.0#remarks
 * @property commonName The common name field in the subject name. The allowed limit is 64 characters and it should be specified.
 * @property countryCode The country code field in the subject name. If present, the country code should be represented by two-letter code defined in ISO 2166-1 (alpha-2). For example: 'US'.
 * @property organization The organization field in the subject name. If present, the allowed limit is 64 characters.
 * @property organizationUnit The organization unit field in the subject name. If present, the allowed limit is 32 characters.
 */
public data class ClientCertificateSubjectDistinguishedNameResponse(
    public val commonName: String? = null,
    public val countryCode: String? = null,
    public val organization: String? = null,
    public val organizationUnit: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.ClientCertificateSubjectDistinguishedNameResponse):
            ClientCertificateSubjectDistinguishedNameResponse =
            ClientCertificateSubjectDistinguishedNameResponse(
                commonName = javaType.commonName().map({ args0 -> args0 }).orElse(null),
                countryCode = javaType.countryCode().map({ args0 -> args0 }).orElse(null),
                organization = javaType.organization().map({ args0 -> args0 }).orElse(null),
                organizationUnit = javaType.organizationUnit().map({ args0 -> args0 }).orElse(null),
            )
    }
}
