@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Thumbprints are used by the service to validate the device permission when authentication is done using self signed certificate.
 * @property primary The primary thumbprint used for validation.
 * @property secondary The secondary thumbprint used for validation.
 */
public data class ClientCertificateThumbprintResponse(
    public val primary: String? = null,
    public val secondary: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.ClientCertificateThumbprintResponse):
            ClientCertificateThumbprintResponse = ClientCertificateThumbprintResponse(
            primary = javaType.primary().map({ args0 -> args0 }).orElse(null),
            secondary = javaType.secondary().map({ args0 -> args0 }).orElse(null),
        )
    }
}
