@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Any
import kotlin.Suppress

/**
 * Information about the delivery for an event subscription with resource identity.
 * @property destination Information about the destination where events have to be delivered for the event subscription.
 * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property identity The identity to use when delivering events.
 */
public data class DeliveryWithResourceIdentityResponse(
    public val destination: Any? = null,
    public val identity: EventSubscriptionIdentityResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.DeliveryWithResourceIdentityResponse):
            DeliveryWithResourceIdentityResponse = DeliveryWithResourceIdentityResponse(
            destination = javaType.destination().map({ args0 -> args0 }).orElse(null),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.EventSubscriptionIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
