@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Filters configuration for the Event Subscription.
 * @property filters An array of filters that are used for filtering event subscriptions.
 * @property includedEventTypes A list of applicable event types that need to be part of the event subscription. If it is desired to subscribe to all default event types, set the IncludedEventTypes to null.
 */
public data class FiltersConfigurationResponse(
    public val filters: List<Any>? = null,
    public val includedEventTypes: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.FiltersConfigurationResponse):
            FiltersConfigurationResponse = FiltersConfigurationResponse(
            filters = javaType.filters().map({ args0 -> args0 }),
            includedEventTypes = javaType.includedEventTypes().map({ args0 -> args0 }),
        )
    }
}
