@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Event Grid Partner Topic.
 * @property activationState Activation state of the partner topic.
 * @property eventTypeInfo Event Type information from the corresponding event channel.
 * @property expirationTimeIfNotActivatedUtc Expiration time of the partner topic. If this timer expires while the partner topic is still never activated,
 * the partner topic and corresponding event channel are deleted.
 * @property id Fully qualified identifier of the resource.
 * @property identity Identity information for the Partner Topic resource.
 * @property location Location of the resource.
 * @property messageForActivation Context or helpful message that can be used during the approval process by the subscriber.
 * @property name Name of the resource.
 * @property partnerRegistrationImmutableId The immutableId of the corresponding partner registration.
 * @property partnerTopicFriendlyDescription Friendly description about the topic. This can be set by the publisher/partner to show custom description for the customer partner topic.
 * This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
 * @property provisioningState Provisioning state of the partner topic.
 * @property source Source associated with this partner topic. This represents a unique partner resource.
 * @property systemData The system metadata relating to Partner Topic resource.
 * @property tags Tags of the resource.
 * @property type Type of the resource.
 */
public data class GetPartnerTopicResult(
    public val activationState: String? = null,
    public val eventTypeInfo: EventTypeInfoResponse? = null,
    public val expirationTimeIfNotActivatedUtc: String? = null,
    public val id: String,
    public val identity: IdentityInfoResponse? = null,
    public val location: String,
    public val messageForActivation: String? = null,
    public val name: String,
    public val partnerRegistrationImmutableId: String? = null,
    public val partnerTopicFriendlyDescription: String? = null,
    public val provisioningState: String,
    public val source: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.GetPartnerTopicResult):
            GetPartnerTopicResult = GetPartnerTopicResult(
            activationState = javaType.activationState().map({ args0 -> args0 }).orElse(null),
            eventTypeInfo = javaType.eventTypeInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.EventTypeInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            expirationTimeIfNotActivatedUtc = javaType.expirationTimeIfNotActivatedUtc().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.eventgrid.kotlin.outputs.IdentityInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            messageForActivation = javaType.messageForActivation().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            partnerRegistrationImmutableId = javaType.partnerRegistrationImmutableId().map({ args0 ->
                args0
            }).orElse(null),
            partnerTopicFriendlyDescription = javaType.partnerTopicFriendlyDescription().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
