@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Additional information about every inline event.
 * @property dataSchemaUrl The dataSchemaUrl for the inline event.
 * @property description The description for the inline event.
 * @property displayName The displayName for the inline event.
 * @property documentationUrl The documentationUrl for the inline event.
 */
public data class InlineEventPropertiesResponse(
    public val dataSchemaUrl: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val documentationUrl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.InlineEventPropertiesResponse):
            InlineEventPropertiesResponse = InlineEventPropertiesResponse(
            dataSchemaUrl = javaType.dataSchemaUrl().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            documentationUrl = javaType.documentationUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
