@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * NumberIn Advanced Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'NumberIn'.
 * @property values The set of filter values.
 */
public data class NumberInAdvancedFilterResponse(
    public val key: String? = null,
    public val operatorType: String,
    public val values: List<Double>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.NumberInAdvancedFilterResponse):
            NumberInAdvancedFilterResponse = NumberInAdvancedFilterResponse(
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            operatorType = javaType.operatorType(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
