@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * NumberNotInRange Filter.
 * @property key The field/property in the event based on which you want to filter.
 * @property operatorType The operator type used for filtering, e.g., NumberIn, StringContains, BoolEquals and others.
 * Expected value is 'NumberNotInRange'.
 * @property values The set of filter values.
 */
public data class NumberNotInRangeFilterResponse(
    public val key: String? = null,
    public val operatorType: String,
    public val values: List<List<Double>>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.eventgrid.outputs.NumberNotInRangeFilterResponse):
            NumberNotInRangeFilterResponse = NumberNotInRangeFilterResponse(
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            operatorType = javaType.operatorType(),
            values = javaType.values().map({ args0 -> args0.map({ args0 -> args0 }) }),
        )
    }
}
