@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.ClusterArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.inputs.ClusterSkuArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.ClusterSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Single Event Hubs Cluster resource in List or Get operations.
 * Azure REST API version: 2022-10-01-preview. Prior API version in Azure Native 1.x: 2018-01-01-preview.
 * Other available API versions: 2023-01-01-preview, 2024-01-01.
 * ## Example Usage
 * ### ClusterPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.EventHub.Cluster("cluster", new()
 *     {
 *         ClusterName = "testCluster",
 *         Location = "South Central US",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.EventHub.Inputs.ClusterSkuArgs
 *         {
 *             Capacity = 1,
 *             Name = "Dedicated",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventhub.NewCluster(ctx, "cluster", &eventhub.ClusterArgs{
 * 			ClusterName:       pulumi.String("testCluster"),
 * 			Location:          pulumi.String("South Central US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &eventhub.ClusterSkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("Dedicated"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventhub.Cluster;
 * import com.pulumi.azurenative.eventhub.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("testCluster")
 *             .location("South Central US")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "Dedicated")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventhub:Cluster testCluster /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/clusters/{clusterName}
 * ```
 * @property clusterName The name of the Event Hubs Cluster.
 * @property location Resource location.
 * @property resourceGroupName Name of the resource group within the azure subscription.
 * @property sku Properties of the cluster SKU.
 * @property supportsScaling A value that indicates whether Scaling is Supported.
 * @property tags Resource tags.
 */
public data class ClusterArgs(
    public val clusterName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<ClusterSkuArgs>? = null,
    public val supportsScaling: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.ClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.ClusterArgs =
        com.pulumi.azurenative.eventhub.ClusterArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .supportsScaling(supportsScaling?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<ClusterSkuArgs>? = null

    private var supportsScaling: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Event Hubs Cluster.
     */
    @JvmName("yahlrnhmaxrbamrc")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ilvwrniitqcrjdij")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("ivxberfkvwevircy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Properties of the cluster SKU.
     */
    @JvmName("pgaraipwvdltkcpy")
    public suspend fun sku(`value`: Output<ClusterSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value A value that indicates whether Scaling is Supported.
     */
    @JvmName("mcwhocwewllpvagr")
    public suspend fun supportsScaling(`value`: Output<Boolean>) {
        this.supportsScaling = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nsaavprmscxxijbc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Event Hubs Cluster.
     */
    @JvmName("uwpmdfgeejfxwuce")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("dajlbpohccbgscft")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("vilnrwkajwmdghgo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Properties of the cluster SKU.
     */
    @JvmName("xbvcjjnqvqgjuewp")
    public suspend fun sku(`value`: ClusterSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Properties of the cluster SKU.
     */
    @JvmName("kjclsnhfyyiowchu")
    public suspend fun sku(argument: suspend ClusterSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value A value that indicates whether Scaling is Supported.
     */
    @JvmName("ngkhdjhlkcpohqwb")
    public suspend fun supportsScaling(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportsScaling = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iqlypwwiastxijwx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nsvdxeimwwjypxlp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        clusterName = clusterName,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        supportsScaling = supportsScaling,
        tags = tags,
    )
}
