@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.EventHubAuthorizationRuleArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.AccessRights
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Single item in a List or Get AuthorizationRule operation
 * Azure REST API version: 2022-10-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2015-08-01, 2023-01-01-preview, 2024-01-01.
 * ## Example Usage
 * ### EventHubAuthorizationRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventHubAuthorizationRule = new AzureNative.EventHub.EventHubAuthorizationRule("eventHubAuthorizationRule", new()
 *     {
 *         AuthorizationRuleName = "sdk-Authrules-2513",
 *         EventHubName = "sdk-EventHub-532",
 *         NamespaceName = "sdk-Namespace-960",
 *         ResourceGroupName = "ArunMonocle",
 *         Rights = new[]
 *         {
 *             "Listen",
 *             "Send",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventhub.NewEventHubAuthorizationRule(ctx, "eventHubAuthorizationRule", &eventhub.EventHubAuthorizationRuleArgs{
 * 			AuthorizationRuleName: pulumi.String("sdk-Authrules-2513"),
 * 			EventHubName:          pulumi.String("sdk-EventHub-532"),
 * 			NamespaceName:         pulumi.String("sdk-Namespace-960"),
 * 			ResourceGroupName:     pulumi.String("ArunMonocle"),
 * 			Rights: pulumi.StringArray{
 * 				pulumi.String("Listen"),
 * 				pulumi.String("Send"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventhub.EventHubAuthorizationRule;
 * import com.pulumi.azurenative.eventhub.EventHubAuthorizationRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventHubAuthorizationRule = new EventHubAuthorizationRule("eventHubAuthorizationRule", EventHubAuthorizationRuleArgs.builder()
 *             .authorizationRuleName("sdk-Authrules-2513")
 *             .eventHubName("sdk-EventHub-532")
 *             .namespaceName("sdk-Namespace-960")
 *             .resourceGroupName("ArunMonocle")
 *             .rights(
 *                 "Listen",
 *                 "Send")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventhub:EventHubAuthorizationRule sdk-Authrules-2513 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/eventhubs/{eventHubName}/authorizationRules/{authorizationRuleName}
 * ```
 * @property authorizationRuleName The authorization rule name.
 * @property eventHubName The Event Hub name
 * @property namespaceName The Namespace name
 * @property resourceGroupName Name of the resource group within the azure subscription.
 * @property rights The rights associated with the rule.
 */
public data class EventHubAuthorizationRuleArgs(
    public val authorizationRuleName: Output<String>? = null,
    public val eventHubName: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rights: Output<List<Either<String, AccessRights>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.EventHubAuthorizationRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.EventHubAuthorizationRuleArgs =
        com.pulumi.azurenative.eventhub.EventHubAuthorizationRuleArgs.builder()
            .authorizationRuleName(authorizationRuleName?.applyValue({ args0 -> args0 }))
            .eventHubName(eventHubName?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rights(
                rights?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [EventHubAuthorizationRuleArgs].
 */
@PulumiTagMarker
public class EventHubAuthorizationRuleArgsBuilder internal constructor() {
    private var authorizationRuleName: Output<String>? = null

    private var eventHubName: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var rights: Output<List<Either<String, AccessRights>>>? = null

    /**
     * @param value The authorization rule name.
     */
    @JvmName("celnjphaicfmnxwd")
    public suspend fun authorizationRuleName(`value`: Output<String>) {
        this.authorizationRuleName = value
    }

    /**
     * @param value The Event Hub name
     */
    @JvmName("haoqnkfkbqakxjry")
    public suspend fun eventHubName(`value`: Output<String>) {
        this.eventHubName = value
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("lwxxeiqswoygfusv")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("fpbdangkhjrnnjpe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The rights associated with the rule.
     */
    @JvmName("ggwinddquwjamjqs")
    public suspend fun rights(`value`: Output<List<Either<String, AccessRights>>>) {
        this.rights = value
    }

    @JvmName("ckpcwbuqosiymjur")
    public suspend fun rights(vararg values: Output<Either<String, AccessRights>>) {
        this.rights = Output.all(values.asList())
    }

    /**
     * @param values The rights associated with the rule.
     */
    @JvmName("wdxljttisupcjpfs")
    public suspend fun rights(values: List<Output<Either<String, AccessRights>>>) {
        this.rights = Output.all(values)
    }

    /**
     * @param value The authorization rule name.
     */
    @JvmName("eqjvdynilxpktspe")
    public suspend fun authorizationRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value The Event Hub name
     */
    @JvmName("byggukmvfyhjjrbu")
    public suspend fun eventHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubName = mapped
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("dpgqvnxfbvhbrvyq")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("uhnftoqdlxwwcnhl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The rights associated with the rule.
     */
    @JvmName("aghxsbmhxdxrctgt")
    public suspend fun rights(`value`: List<Either<String, AccessRights>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param values The rights associated with the rule.
     */
    @JvmName("eccrgwsqdrpbwlrr")
    public suspend fun rights(vararg values: Either<String, AccessRights>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    internal fun build(): EventHubAuthorizationRuleArgs = EventHubAuthorizationRuleArgs(
        authorizationRuleName = authorizationRuleName,
        eventHubName = eventHubName,
        namespaceName = namespaceName,
        resourceGroupName = resourceGroupName,
        rights = rights,
    )
}
