@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.EventhubFunctions.getApplicationGroupPlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.getClusterPlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.getConsumerGroupPlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.getDisasterRecoveryConfigPlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.getEventHubAuthorizationRulePlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.getEventHubPlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.getNamespaceAuthorizationRulePlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.getNamespaceIpFilterRulePlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.getNamespaceNetworkRuleSetPlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.getNamespacePlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.getNamespaceVirtualNetworkRulePlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.getSchemaRegistryPlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.listDisasterRecoveryConfigKeysPlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.listEventHubKeysPlain
import com.pulumi.azurenative.eventhub.EventhubFunctions.listNamespaceKeysPlain
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetApplicationGroupPlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetApplicationGroupPlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetConsumerGroupPlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetConsumerGroupPlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetDisasterRecoveryConfigPlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetDisasterRecoveryConfigPlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetEventHubAuthorizationRulePlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetEventHubAuthorizationRulePlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetEventHubPlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetEventHubPlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetNamespaceAuthorizationRulePlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetNamespaceAuthorizationRulePlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetNamespaceIpFilterRulePlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetNamespaceIpFilterRulePlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetNamespaceNetworkRuleSetPlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetNamespaceNetworkRuleSetPlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetNamespacePlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetNamespacePlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetNamespaceVirtualNetworkRulePlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetNamespaceVirtualNetworkRulePlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetSchemaRegistryPlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.GetSchemaRegistryPlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.ListDisasterRecoveryConfigKeysPlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.ListDisasterRecoveryConfigKeysPlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.ListEventHubKeysPlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.ListEventHubKeysPlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.ListNamespaceKeysPlainArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.ListNamespaceKeysPlainArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetApplicationGroupResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetClusterResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetConsumerGroupResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetDisasterRecoveryConfigResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetEventHubAuthorizationRuleResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetEventHubResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetNamespaceAuthorizationRuleResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetNamespaceIpFilterRuleResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetNamespaceNetworkRuleSetResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetNamespaceResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetNamespaceVirtualNetworkRuleResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetSchemaRegistryResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.ListDisasterRecoveryConfigKeysResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.ListEventHubKeysResult
import com.pulumi.azurenative.eventhub.kotlin.outputs.ListNamespaceKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetApplicationGroupResult.Companion.toKotlin as getApplicationGroupResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetConsumerGroupResult.Companion.toKotlin as getConsumerGroupResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetDisasterRecoveryConfigResult.Companion.toKotlin as getDisasterRecoveryConfigResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetEventHubAuthorizationRuleResult.Companion.toKotlin as getEventHubAuthorizationRuleResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetEventHubResult.Companion.toKotlin as getEventHubResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetNamespaceAuthorizationRuleResult.Companion.toKotlin as getNamespaceAuthorizationRuleResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetNamespaceIpFilterRuleResult.Companion.toKotlin as getNamespaceIpFilterRuleResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetNamespaceNetworkRuleSetResult.Companion.toKotlin as getNamespaceNetworkRuleSetResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetNamespaceResult.Companion.toKotlin as getNamespaceResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetNamespaceVirtualNetworkRuleResult.Companion.toKotlin as getNamespaceVirtualNetworkRuleResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.GetSchemaRegistryResult.Companion.toKotlin as getSchemaRegistryResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.ListDisasterRecoveryConfigKeysResult.Companion.toKotlin as listDisasterRecoveryConfigKeysResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.ListEventHubKeysResult.Companion.toKotlin as listEventHubKeysResultToKotlin
import com.pulumi.azurenative.eventhub.kotlin.outputs.ListNamespaceKeysResult.Companion.toKotlin as listNamespaceKeysResultToKotlin

public object EventhubFunctions {
    /**
     * Gets an ApplicationGroup for a Namespace.
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2023-01-01-preview, 2024-01-01.
     * @param argument null
     * @return The Application Group object
     */
    public suspend fun getApplicationGroup(argument: GetApplicationGroupPlainArgs):
        GetApplicationGroupResult =
        getApplicationGroupResultToKotlin(getApplicationGroupPlain(argument.toJava()).await())

    /**
     * @see [getApplicationGroup].
     * @param applicationGroupName The Application Group name
     * @param namespaceName The Namespace name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @return The Application Group object
     */
    public suspend fun getApplicationGroup(
        applicationGroupName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetApplicationGroupResult {
        val argument = GetApplicationGroupPlainArgs(
            applicationGroupName = applicationGroupName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getApplicationGroupResultToKotlin(getApplicationGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplicationGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;GetApplicationGroupPlainArgs].
     * @return The Application Group object
     */
    public suspend
    fun getApplicationGroup(argument: suspend GetApplicationGroupPlainArgsBuilder.() -> Unit):
        GetApplicationGroupResult {
        val builder = GetApplicationGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationGroupResultToKotlin(getApplicationGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the resource description of the specified Event Hubs Cluster.
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2023-01-01-preview, 2024-01-01.
     * @param argument null
     * @return Single Event Hubs Cluster resource in List or Get operations.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterName The name of the Event Hubs Cluster.
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @return Single Event Hubs Cluster resource in List or Get operations.
     */
    public suspend fun getCluster(clusterName: String, resourceGroupName: String): GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return Single Event Hubs Cluster resource in List or Get operations.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit):
        GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a description for the specified consumer group.
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2015-08-01, 2023-01-01-preview, 2024-01-01.
     * @param argument null
     * @return Single item in List or Get Consumer group operation
     */
    public suspend fun getConsumerGroup(argument: GetConsumerGroupPlainArgs): GetConsumerGroupResult =
        getConsumerGroupResultToKotlin(getConsumerGroupPlain(argument.toJava()).await())

    /**
     * @see [getConsumerGroup].
     * @param consumerGroupName The consumer group name
     * @param eventHubName The Event Hub name
     * @param namespaceName The Namespace name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @return Single item in List or Get Consumer group operation
     */
    public suspend fun getConsumerGroup(
        consumerGroupName: String,
        eventHubName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetConsumerGroupResult {
        val argument = GetConsumerGroupPlainArgs(
            consumerGroupName = consumerGroupName,
            eventHubName = eventHubName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getConsumerGroupResultToKotlin(getConsumerGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getConsumerGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;GetConsumerGroupPlainArgs].
     * @return Single item in List or Get Consumer group operation
     */
    public suspend
    fun getConsumerGroup(argument: suspend GetConsumerGroupPlainArgsBuilder.() -> Unit):
        GetConsumerGroupResult {
        val builder = GetConsumerGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConsumerGroupResultToKotlin(getConsumerGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves Alias(Disaster Recovery configuration) for primary or secondary namespace
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2023-01-01-preview, 2024-01-01.
     * @param argument null
     * @return Single item in List or Get Alias(Disaster Recovery configuration) operation
     */
    public suspend fun getDisasterRecoveryConfig(argument: GetDisasterRecoveryConfigPlainArgs):
        GetDisasterRecoveryConfigResult =
        getDisasterRecoveryConfigResultToKotlin(getDisasterRecoveryConfigPlain(argument.toJava()).await())

    /**
     * @see [getDisasterRecoveryConfig].
     * @param alias The Disaster Recovery configuration name
     * @param namespaceName The Namespace name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @return Single item in List or Get Alias(Disaster Recovery configuration) operation
     */
    public suspend fun getDisasterRecoveryConfig(
        alias: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetDisasterRecoveryConfigResult {
        val argument = GetDisasterRecoveryConfigPlainArgs(
            alias = alias,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getDisasterRecoveryConfigResultToKotlin(getDisasterRecoveryConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getDisasterRecoveryConfig].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;GetDisasterRecoveryConfigPlainArgs].
     * @return Single item in List or Get Alias(Disaster Recovery configuration) operation
     */
    public suspend
    fun getDisasterRecoveryConfig(argument: suspend GetDisasterRecoveryConfigPlainArgsBuilder.() -> Unit):
        GetDisasterRecoveryConfigResult {
        val builder = GetDisasterRecoveryConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDisasterRecoveryConfigResultToKotlin(getDisasterRecoveryConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an Event Hubs description for the specified Event Hub.
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2015-08-01, 2023-01-01-preview, 2024-01-01.
     * @param argument null
     * @return Single item in List or Get Event Hub operation
     */
    public suspend fun getEventHub(argument: GetEventHubPlainArgs): GetEventHubResult =
        getEventHubResultToKotlin(getEventHubPlain(argument.toJava()).await())

    /**
     * @see [getEventHub].
     * @param eventHubName The Event Hub name
     * @param namespaceName The Namespace name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @return Single item in List or Get Event Hub operation
     */
    public suspend fun getEventHub(
        eventHubName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetEventHubResult {
        val argument = GetEventHubPlainArgs(
            eventHubName = eventHubName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getEventHubResultToKotlin(getEventHubPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventHub].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;GetEventHubPlainArgs].
     * @return Single item in List or Get Event Hub operation
     */
    public suspend fun getEventHub(argument: suspend GetEventHubPlainArgsBuilder.() -> Unit):
        GetEventHubResult {
        val builder = GetEventHubPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventHubResultToKotlin(getEventHubPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an AuthorizationRule for an Event Hub by rule name.
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2015-08-01, 2023-01-01-preview, 2024-01-01.
     * @param argument null
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend fun getEventHubAuthorizationRule(argument: GetEventHubAuthorizationRulePlainArgs):
        GetEventHubAuthorizationRuleResult =
        getEventHubAuthorizationRuleResultToKotlin(getEventHubAuthorizationRulePlain(argument.toJava()).await())

    /**
     * @see [getEventHubAuthorizationRule].
     * @param authorizationRuleName The authorization rule name.
     * @param eventHubName The Event Hub name
     * @param namespaceName The Namespace name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend fun getEventHubAuthorizationRule(
        authorizationRuleName: String,
        eventHubName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetEventHubAuthorizationRuleResult {
        val argument = GetEventHubAuthorizationRulePlainArgs(
            authorizationRuleName = authorizationRuleName,
            eventHubName = eventHubName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getEventHubAuthorizationRuleResultToKotlin(getEventHubAuthorizationRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getEventHubAuthorizationRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;GetEventHubAuthorizationRulePlainArgs].
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend
    fun getEventHubAuthorizationRule(argument: suspend GetEventHubAuthorizationRulePlainArgsBuilder.() -> Unit):
        GetEventHubAuthorizationRuleResult {
        val builder = GetEventHubAuthorizationRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventHubAuthorizationRuleResultToKotlin(getEventHubAuthorizationRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the description of the specified namespace.
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2015-08-01, 2023-01-01-preview, 2024-01-01.
     * @param argument null
     * @return Single Namespace item in List or Get Operation
     */
    public suspend fun getNamespace(argument: GetNamespacePlainArgs): GetNamespaceResult =
        getNamespaceResultToKotlin(getNamespacePlain(argument.toJava()).await())

    /**
     * @see [getNamespace].
     * @param namespaceName The Namespace name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @return Single Namespace item in List or Get Operation
     */
    public suspend fun getNamespace(namespaceName: String, resourceGroupName: String):
        GetNamespaceResult {
        val argument = GetNamespacePlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNamespaceResultToKotlin(getNamespacePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;GetNamespacePlainArgs].
     * @return Single Namespace item in List or Get Operation
     */
    public suspend fun getNamespace(argument: suspend GetNamespacePlainArgsBuilder.() -> Unit):
        GetNamespaceResult {
        val builder = GetNamespacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceResultToKotlin(getNamespacePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an AuthorizationRule for a Namespace by rule name.
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2015-08-01, 2023-01-01-preview, 2024-01-01.
     * @param argument null
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend
    fun getNamespaceAuthorizationRule(argument: GetNamespaceAuthorizationRulePlainArgs):
        GetNamespaceAuthorizationRuleResult =
        getNamespaceAuthorizationRuleResultToKotlin(getNamespaceAuthorizationRulePlain(argument.toJava()).await())

    /**
     * @see [getNamespaceAuthorizationRule].
     * @param authorizationRuleName The authorization rule name.
     * @param namespaceName The Namespace name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend fun getNamespaceAuthorizationRule(
        authorizationRuleName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetNamespaceAuthorizationRuleResult {
        val argument = GetNamespaceAuthorizationRulePlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNamespaceAuthorizationRuleResultToKotlin(getNamespaceAuthorizationRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaceAuthorizationRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;GetNamespaceAuthorizationRulePlainArgs].
     * @return Single item in a List or Get AuthorizationRule operation
     */
    public suspend
    fun getNamespaceAuthorizationRule(argument: suspend GetNamespaceAuthorizationRulePlainArgsBuilder.() -> Unit):
        GetNamespaceAuthorizationRuleResult {
        val builder = GetNamespaceAuthorizationRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceAuthorizationRuleResultToKotlin(getNamespaceAuthorizationRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an IpFilterRule for a Namespace by rule name.
     * Azure REST API version: 2018-01-01-preview.
     * @param argument null
     * @return Single item in a List or Get IpFilterRules operation
     */
    public suspend fun getNamespaceIpFilterRule(argument: GetNamespaceIpFilterRulePlainArgs):
        GetNamespaceIpFilterRuleResult =
        getNamespaceIpFilterRuleResultToKotlin(getNamespaceIpFilterRulePlain(argument.toJava()).await())

    /**
     * @see [getNamespaceIpFilterRule].
     * @param ipFilterRuleName The IP Filter Rule name.
     * @param namespaceName The Namespace name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @return Single item in a List or Get IpFilterRules operation
     */
    public suspend fun getNamespaceIpFilterRule(
        ipFilterRuleName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetNamespaceIpFilterRuleResult {
        val argument = GetNamespaceIpFilterRulePlainArgs(
            ipFilterRuleName = ipFilterRuleName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNamespaceIpFilterRuleResultToKotlin(getNamespaceIpFilterRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaceIpFilterRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;GetNamespaceIpFilterRulePlainArgs].
     * @return Single item in a List or Get IpFilterRules operation
     */
    public suspend
    fun getNamespaceIpFilterRule(argument: suspend GetNamespaceIpFilterRulePlainArgsBuilder.() -> Unit):
        GetNamespaceIpFilterRuleResult {
        val builder = GetNamespaceIpFilterRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceIpFilterRuleResultToKotlin(getNamespaceIpFilterRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets NetworkRuleSet for a Namespace.
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2023-01-01-preview, 2024-01-01.
     * @param argument null
     * @return Description of topic resource.
     */
    public suspend fun getNamespaceNetworkRuleSet(argument: GetNamespaceNetworkRuleSetPlainArgs):
        GetNamespaceNetworkRuleSetResult =
        getNamespaceNetworkRuleSetResultToKotlin(getNamespaceNetworkRuleSetPlain(argument.toJava()).await())

    /**
     * @see [getNamespaceNetworkRuleSet].
     * @param namespaceName The Namespace name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @return Description of topic resource.
     */
    public suspend fun getNamespaceNetworkRuleSet(namespaceName: String, resourceGroupName: String):
        GetNamespaceNetworkRuleSetResult {
        val argument = GetNamespaceNetworkRuleSetPlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNamespaceNetworkRuleSetResultToKotlin(getNamespaceNetworkRuleSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaceNetworkRuleSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;GetNamespaceNetworkRuleSetPlainArgs].
     * @return Description of topic resource.
     */
    public suspend
    fun getNamespaceNetworkRuleSet(argument: suspend GetNamespaceNetworkRuleSetPlainArgsBuilder.() -> Unit):
        GetNamespaceNetworkRuleSetResult {
        val builder = GetNamespaceNetworkRuleSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceNetworkRuleSetResultToKotlin(getNamespaceNetworkRuleSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an VirtualNetworkRule for a Namespace by rule name.
     * Azure REST API version: 2018-01-01-preview.
     * @param argument null
     * @return Single item in a List or Get VirtualNetworkRules operation
     */
    public suspend
    fun getNamespaceVirtualNetworkRule(argument: GetNamespaceVirtualNetworkRulePlainArgs):
        GetNamespaceVirtualNetworkRuleResult =
        getNamespaceVirtualNetworkRuleResultToKotlin(getNamespaceVirtualNetworkRulePlain(argument.toJava()).await())

    /**
     * @see [getNamespaceVirtualNetworkRule].
     * @param namespaceName The Namespace name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param virtualNetworkRuleName The Virtual Network Rule name.
     * @return Single item in a List or Get VirtualNetworkRules operation
     */
    public suspend fun getNamespaceVirtualNetworkRule(
        namespaceName: String,
        resourceGroupName: String,
        virtualNetworkRuleName: String,
    ): GetNamespaceVirtualNetworkRuleResult {
        val argument = GetNamespaceVirtualNetworkRulePlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
            virtualNetworkRuleName = virtualNetworkRuleName,
        )
        return getNamespaceVirtualNetworkRuleResultToKotlin(getNamespaceVirtualNetworkRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaceVirtualNetworkRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;GetNamespaceVirtualNetworkRulePlainArgs].
     * @return Single item in a List or Get VirtualNetworkRules operation
     */
    public suspend
    fun getNamespaceVirtualNetworkRule(argument: suspend GetNamespaceVirtualNetworkRulePlainArgsBuilder.() -> Unit):
        GetNamespaceVirtualNetworkRuleResult {
        val builder = GetNamespaceVirtualNetworkRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceVirtualNetworkRuleResultToKotlin(getNamespaceVirtualNetworkRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a description for the specified Private Endpoint Connection name.
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2023-01-01-preview, 2024-01-01.
     * @param argument null
     * @return Properties of the PrivateEndpointConnection.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param namespaceName The Namespace name
     * @param privateEndpointConnectionName The PrivateEndpointConnection name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @return Properties of the PrivateEndpointConnection.
     */
    public suspend fun getPrivateEndpointConnection(
        namespaceName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            namespaceName = namespaceName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return Properties of the PrivateEndpointConnection.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of an EventHub schema group.
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2023-01-01-preview, 2024-01-01.
     * @param argument null
     * @return Single item in List or Get Schema Group operation
     */
    public suspend fun getSchemaRegistry(argument: GetSchemaRegistryPlainArgs):
        GetSchemaRegistryResult =
        getSchemaRegistryResultToKotlin(getSchemaRegistryPlain(argument.toJava()).await())

    /**
     * @see [getSchemaRegistry].
     * @param namespaceName The Namespace name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @param schemaGroupName The Schema Group name
     * @return Single item in List or Get Schema Group operation
     */
    public suspend fun getSchemaRegistry(
        namespaceName: String,
        resourceGroupName: String,
        schemaGroupName: String,
    ): GetSchemaRegistryResult {
        val argument = GetSchemaRegistryPlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
            schemaGroupName = schemaGroupName,
        )
        return getSchemaRegistryResultToKotlin(getSchemaRegistryPlain(argument.toJava()).await())
    }

    /**
     * @see [getSchemaRegistry].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;GetSchemaRegistryPlainArgs].
     * @return Single item in List or Get Schema Group operation
     */
    public suspend
    fun getSchemaRegistry(argument: suspend GetSchemaRegistryPlainArgsBuilder.() -> Unit):
        GetSchemaRegistryResult {
        val builder = GetSchemaRegistryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSchemaRegistryResultToKotlin(getSchemaRegistryPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the primary and secondary connection strings for the Namespace.
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2023-01-01-preview, 2024-01-01.
     * @param argument null
     * @return Namespace/EventHub Connection String
     */
    public suspend
    fun listDisasterRecoveryConfigKeys(argument: ListDisasterRecoveryConfigKeysPlainArgs):
        ListDisasterRecoveryConfigKeysResult =
        listDisasterRecoveryConfigKeysResultToKotlin(listDisasterRecoveryConfigKeysPlain(argument.toJava()).await())

    /**
     * @see [listDisasterRecoveryConfigKeys].
     * @param alias The Disaster Recovery configuration name
     * @param authorizationRuleName The authorization rule name.
     * @param namespaceName The Namespace name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @return Namespace/EventHub Connection String
     */
    public suspend fun listDisasterRecoveryConfigKeys(
        alias: String,
        authorizationRuleName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): ListDisasterRecoveryConfigKeysResult {
        val argument = ListDisasterRecoveryConfigKeysPlainArgs(
            alias = alias,
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return listDisasterRecoveryConfigKeysResultToKotlin(listDisasterRecoveryConfigKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listDisasterRecoveryConfigKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;ListDisasterRecoveryConfigKeysPlainArgs].
     * @return Namespace/EventHub Connection String
     */
    public suspend
    fun listDisasterRecoveryConfigKeys(argument: suspend ListDisasterRecoveryConfigKeysPlainArgsBuilder.() -> Unit):
        ListDisasterRecoveryConfigKeysResult {
        val builder = ListDisasterRecoveryConfigKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDisasterRecoveryConfigKeysResultToKotlin(listDisasterRecoveryConfigKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the ACS and SAS connection strings for the Event Hub.
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2015-08-01, 2023-01-01-preview, 2024-01-01.
     * @param argument null
     * @return Namespace/EventHub Connection String
     */
    public suspend fun listEventHubKeys(argument: ListEventHubKeysPlainArgs): ListEventHubKeysResult =
        listEventHubKeysResultToKotlin(listEventHubKeysPlain(argument.toJava()).await())

    /**
     * @see [listEventHubKeys].
     * @param authorizationRuleName The authorization rule name.
     * @param eventHubName The Event Hub name
     * @param namespaceName The Namespace name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @return Namespace/EventHub Connection String
     */
    public suspend fun listEventHubKeys(
        authorizationRuleName: String,
        eventHubName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): ListEventHubKeysResult {
        val argument = ListEventHubKeysPlainArgs(
            authorizationRuleName = authorizationRuleName,
            eventHubName = eventHubName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return listEventHubKeysResultToKotlin(listEventHubKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listEventHubKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;ListEventHubKeysPlainArgs].
     * @return Namespace/EventHub Connection String
     */
    public suspend
    fun listEventHubKeys(argument: suspend ListEventHubKeysPlainArgsBuilder.() -> Unit):
        ListEventHubKeysResult {
        val builder = ListEventHubKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listEventHubKeysResultToKotlin(listEventHubKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the primary and secondary connection strings for the Namespace.
     * Azure REST API version: 2022-10-01-preview.
     * Other available API versions: 2015-08-01, 2023-01-01-preview, 2024-01-01.
     * @param argument null
     * @return Namespace/EventHub Connection String
     */
    public suspend fun listNamespaceKeys(argument: ListNamespaceKeysPlainArgs):
        ListNamespaceKeysResult =
        listNamespaceKeysResultToKotlin(listNamespaceKeysPlain(argument.toJava()).await())

    /**
     * @see [listNamespaceKeys].
     * @param authorizationRuleName The authorization rule name.
     * @param namespaceName The Namespace name
     * @param resourceGroupName Name of the resource group within the azure subscription.
     * @return Namespace/EventHub Connection String
     */
    public suspend fun listNamespaceKeys(
        authorizationRuleName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): ListNamespaceKeysResult {
        val argument = ListNamespaceKeysPlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return listNamespaceKeysResultToKotlin(listNamespaceKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listNamespaceKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;eventhub&#46;kotlin&#46;inputs&#46;ListNamespaceKeysPlainArgs].
     * @return Namespace/EventHub Connection String
     */
    public suspend
    fun listNamespaceKeys(argument: suspend ListNamespaceKeysPlainArgsBuilder.() -> Unit):
        ListNamespaceKeysResult {
        val builder = ListNamespaceKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listNamespaceKeysResultToKotlin(listNamespaceKeysPlain(builtArgument.toJava()).await())
    }
}
