@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.NamespaceArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.eventhub.kotlin.enums.TlsVersion
import com.pulumi.azurenative.eventhub.kotlin.inputs.EncryptionArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.EncryptionArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.PrivateEndpointConnectionArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.PrivateEndpointConnectionArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Single Namespace item in List or Get Operation
 * Azure REST API version: 2022-10-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2015-08-01, 2023-01-01-preview, 2024-01-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventhub:Namespace NamespaceSample /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}
 * ```
 * @property alternateName Alternate name specified when alias and namespace names are same.
 * @property clusterArmId Cluster ARM ID of the Namespace.
 * @property disableLocalAuth This property disables SAS authentication for the Event Hubs namespace.
 * @property encryption Properties of BYOK Encryption description
 * @property identity Properties of BYOK Identity description
 * @property isAutoInflateEnabled Value that indicates whether AutoInflate is enabled for eventhub namespace.
 * @property kafkaEnabled Value that indicates whether Kafka is enabled for eventhub namespace.
 * @property location Resource location.
 * @property maximumThroughputUnits Upper limit of throughput units when AutoInflate is enabled, value should be within 0 to 20 throughput units. ( '0' if AutoInflateEnabled = true)
 * @property minimumTlsVersion The minimum TLS version for the cluster to support, e.g. '1.2'
 * @property namespaceName The Namespace name
 * @property privateEndpointConnections List of private endpoint connections.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled.
 * @property resourceGroupName Name of the resource group within the azure subscription.
 * @property sku Properties of sku resource
 * @property tags Resource tags.
 * @property zoneRedundant Enabling this property creates a Standard Event Hubs Namespace in regions supported availability zones.
 */
public data class NamespaceArgs(
    public val alternateName: Output<String>? = null,
    public val clusterArmId: Output<String>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val encryption: Output<EncryptionArgs>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val isAutoInflateEnabled: Output<Boolean>? = null,
    public val kafkaEnabled: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val maximumThroughputUnits: Output<Int>? = null,
    public val minimumTlsVersion: Output<Either<String, TlsVersion>>? = null,
    public val namespaceName: Output<String>? = null,
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneRedundant: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.NamespaceArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.NamespaceArgs =
        com.pulumi.azurenative.eventhub.NamespaceArgs.builder()
            .alternateName(alternateName?.applyValue({ args0 -> args0 }))
            .clusterArmId(clusterArmId?.applyValue({ args0 -> args0 }))
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .isAutoInflateEnabled(isAutoInflateEnabled?.applyValue({ args0 -> args0 }))
            .kafkaEnabled(kafkaEnabled?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maximumThroughputUnits(maximumThroughputUnits?.applyValue({ args0 -> args0 }))
            .minimumTlsVersion(
                minimumTlsVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .privateEndpointConnections(
                privateEndpointConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneRedundant(zoneRedundant?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamespaceArgs].
 */
@PulumiTagMarker
public class NamespaceArgsBuilder internal constructor() {
    private var alternateName: Output<String>? = null

    private var clusterArmId: Output<String>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var encryption: Output<EncryptionArgs>? = null

    private var identity: Output<IdentityArgs>? = null

    private var isAutoInflateEnabled: Output<Boolean>? = null

    private var kafkaEnabled: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var maximumThroughputUnits: Output<Int>? = null

    private var minimumTlsVersion: Output<Either<String, TlsVersion>>? = null

    private var namespaceName: Output<String>? = null

    private var privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneRedundant: Output<Boolean>? = null

    /**
     * @param value Alternate name specified when alias and namespace names are same.
     */
    @JvmName("avykmsdmcaqtlfds")
    public suspend fun alternateName(`value`: Output<String>) {
        this.alternateName = value
    }

    /**
     * @param value Cluster ARM ID of the Namespace.
     */
    @JvmName("etyqbsixmqkigevf")
    public suspend fun clusterArmId(`value`: Output<String>) {
        this.clusterArmId = value
    }

    /**
     * @param value This property disables SAS authentication for the Event Hubs namespace.
     */
    @JvmName("pessytvxvqwmupaq")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value Properties of BYOK Encryption description
     */
    @JvmName("wqgfycousictduwl")
    public suspend fun encryption(`value`: Output<EncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value Properties of BYOK Identity description
     */
    @JvmName("vmimlisdinoqguux")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Value that indicates whether AutoInflate is enabled for eventhub namespace.
     */
    @JvmName("epxssnjesdjgcedx")
    public suspend fun isAutoInflateEnabled(`value`: Output<Boolean>) {
        this.isAutoInflateEnabled = value
    }

    /**
     * @param value Value that indicates whether Kafka is enabled for eventhub namespace.
     */
    @JvmName("auiujnuwkdwrebhc")
    public suspend fun kafkaEnabled(`value`: Output<Boolean>) {
        this.kafkaEnabled = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("rruqlsrcdpyunaul")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Upper limit of throughput units when AutoInflate is enabled, value should be within 0 to 20 throughput units. ( '0' if AutoInflateEnabled = true)
     */
    @JvmName("lwauhigtgkyrexsd")
    public suspend fun maximumThroughputUnits(`value`: Output<Int>) {
        this.maximumThroughputUnits = value
    }

    /**
     * @param value The minimum TLS version for the cluster to support, e.g. '1.2'
     */
    @JvmName("rpdflqgwywvwkllc")
    public suspend fun minimumTlsVersion(`value`: Output<Either<String, TlsVersion>>) {
        this.minimumTlsVersion = value
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("hvdeafhhvxhneyxv")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value List of private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("qcnlynnxceuwnhmh")
    public suspend
    fun privateEndpointConnections(`value`: Output<List<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = value
    }

    @JvmName("rgedeaasodparewl")
    public suspend fun privateEndpointConnections(
        vararg
        values: Output<PrivateEndpointConnectionArgs>,
    ) {
        this.privateEndpointConnections = Output.all(values.asList())
    }

    /**
     * @param values List of private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("ytsxtvqqydragrri")
    public suspend
    fun privateEndpointConnections(values: List<Output<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = Output.all(values)
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     */
    @JvmName("mtatgsrkwynuapxu")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("hhavyithlocjefwv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Properties of sku resource
     */
    @JvmName("ksmlpyjwfnibxxvv")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("yjnecvoyjiwnbnkk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Enabling this property creates a Standard Event Hubs Namespace in regions supported availability zones.
     */
    @JvmName("itkiytwperarnoqu")
    public suspend fun zoneRedundant(`value`: Output<Boolean>) {
        this.zoneRedundant = value
    }

    /**
     * @param value Alternate name specified when alias and namespace names are same.
     */
    @JvmName("mjfgkuloldodcior")
    public suspend fun alternateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alternateName = mapped
    }

    /**
     * @param value Cluster ARM ID of the Namespace.
     */
    @JvmName("xwfbdhcpagkwptsc")
    public suspend fun clusterArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterArmId = mapped
    }

    /**
     * @param value This property disables SAS authentication for the Event Hubs namespace.
     */
    @JvmName("umkalapouaairfdk")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value Properties of BYOK Encryption description
     */
    @JvmName("oqeupwwtquroqgxi")
    public suspend fun encryption(`value`: EncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Properties of BYOK Encryption description
     */
    @JvmName("mucuttfeepiapxuk")
    public suspend fun encryption(argument: suspend EncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Properties of BYOK Identity description
     */
    @JvmName("mjyurxwtqafkvgjx")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Properties of BYOK Identity description
     */
    @JvmName("cxqohixhcvhvrcal")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Value that indicates whether AutoInflate is enabled for eventhub namespace.
     */
    @JvmName("mexhmuhqbvppialh")
    public suspend fun isAutoInflateEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAutoInflateEnabled = mapped
    }

    /**
     * @param value Value that indicates whether Kafka is enabled for eventhub namespace.
     */
    @JvmName("mrgmcyipuyjwqpie")
    public suspend fun kafkaEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaEnabled = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("jawtevigbnvhsuji")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Upper limit of throughput units when AutoInflate is enabled, value should be within 0 to 20 throughput units. ( '0' if AutoInflateEnabled = true)
     */
    @JvmName("vcrjltioqovyxkar")
    public suspend fun maximumThroughputUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumThroughputUnits = mapped
    }

    /**
     * @param value The minimum TLS version for the cluster to support, e.g. '1.2'
     */
    @JvmName("cbtjlsinpiflfeyr")
    public suspend fun minimumTlsVersion(`value`: Either<String, TlsVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value The minimum TLS version for the cluster to support, e.g. '1.2'
     */
    @JvmName("hubnkcipifgkdhhv")
    public fun minimumTlsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value The minimum TLS version for the cluster to support, e.g. '1.2'
     */
    @JvmName("chmcvtkdbukwsrfd")
    public fun minimumTlsVersion(`value`: TlsVersion) {
        val toBeMapped = Either.ofRight<String, TlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("cdvipwiufxdxuoql")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value List of private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("waytbqwsxxdcxxrq")
    public suspend fun privateEndpointConnections(`value`: List<PrivateEndpointConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument List of private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("bcmkobpdnxsapygc")
    public suspend
    fun privateEndpointConnections(argument: List<suspend PrivateEndpointConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument List of private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("xyeatnirlpyvrmma")
    public suspend fun privateEndpointConnections(
        vararg
        argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument List of private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("lylclbgxergqqlnx")
    public suspend
    fun privateEndpointConnections(argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param values List of private endpoint connections.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("bqtmgspnutmelewu")
    public suspend fun privateEndpointConnections(vararg values: PrivateEndpointConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     */
    @JvmName("lixofcobvvvsutrw")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     */
    @JvmName("jaanfluqakjsykst")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled.
     */
    @JvmName("qaqvkrxkuqkfaifi")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("cjyfeafbufaimjod")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Properties of sku resource
     */
    @JvmName("iyuuxksootqccnus")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Properties of sku resource
     */
    @JvmName("wbyweiefkforeyhk")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ggyrimidxlbbimqa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("lbypqfkjsnvacuaj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Enabling this property creates a Standard Event Hubs Namespace in regions supported availability zones.
     */
    @JvmName("onvrxmhfnmotxtec")
    public suspend fun zoneRedundant(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundant = mapped
    }

    internal fun build(): NamespaceArgs = NamespaceArgs(
        alternateName = alternateName,
        clusterArmId = clusterArmId,
        disableLocalAuth = disableLocalAuth,
        encryption = encryption,
        identity = identity,
        isAutoInflateEnabled = isAutoInflateEnabled,
        kafkaEnabled = kafkaEnabled,
        location = location,
        maximumThroughputUnits = maximumThroughputUnits,
        minimumTlsVersion = minimumTlsVersion,
        namespaceName = namespaceName,
        privateEndpointConnections = privateEndpointConnections,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        zoneRedundant = zoneRedundant,
    )
}
