@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin

import com.pulumi.azurenative.eventhub.NamespaceNetworkRuleSetArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.DefaultAction
import com.pulumi.azurenative.eventhub.kotlin.enums.PublicNetworkAccessFlag
import com.pulumi.azurenative.eventhub.kotlin.inputs.NWRuleSetIpRulesArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.NWRuleSetIpRulesArgsBuilder
import com.pulumi.azurenative.eventhub.kotlin.inputs.NWRuleSetVirtualNetworkRulesArgs
import com.pulumi.azurenative.eventhub.kotlin.inputs.NWRuleSetVirtualNetworkRulesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Description of topic resource.
 * Azure REST API version: 2022-10-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2023-01-01-preview, 2024-01-01.
 * ## Example Usage
 * ### NameSpaceNetworkRuleSetCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceNetworkRuleSet = new AzureNative.EventHub.NamespaceNetworkRuleSet("namespaceNetworkRuleSet", new()
 *     {
 *         DefaultAction = "Deny",
 *         IpRules = new[]
 *         {
 *             new AzureNative.EventHub.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = "Allow",
 *                 IpMask = "1.1.1.1",
 *             },
 *             new AzureNative.EventHub.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = "Allow",
 *                 IpMask = "1.1.1.2",
 *             },
 *             new AzureNative.EventHub.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = "Allow",
 *                 IpMask = "1.1.1.3",
 *             },
 *             new AzureNative.EventHub.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = "Allow",
 *                 IpMask = "1.1.1.4",
 *             },
 *             new AzureNative.EventHub.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = "Allow",
 *                 IpMask = "1.1.1.5",
 *             },
 *         },
 *         NamespaceName = "sdk-Namespace-6019",
 *         ResourceGroupName = "ResourceGroup",
 *         VirtualNetworkRules = new[]
 *         {
 *             new AzureNative.EventHub.Inputs.NWRuleSetVirtualNetworkRulesArgs
 *             {
 *                 IgnoreMissingVnetServiceEndpoint = true,
 *                 Subnet = new AzureNative.EventHub.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2",
 *                 },
 *             },
 *             new AzureNative.EventHub.Inputs.NWRuleSetVirtualNetworkRulesArgs
 *             {
 *                 IgnoreMissingVnetServiceEndpoint = false,
 *                 Subnet = new AzureNative.EventHub.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3",
 *                 },
 *             },
 *             new AzureNative.EventHub.Inputs.NWRuleSetVirtualNetworkRulesArgs
 *             {
 *                 IgnoreMissingVnetServiceEndpoint = false,
 *                 Subnet = new AzureNative.EventHub.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventhub.NewNamespaceNetworkRuleSet(ctx, "namespaceNetworkRuleSet", &eventhub.NamespaceNetworkRuleSetArgs{
 * 			DefaultAction: pulumi.String("Deny"),
 * 			IpRules: []eventhub.NWRuleSetIpRulesArgs{
 * 				{
 * 					Action: pulumi.String("Allow"),
 * 					IpMask: pulumi.String("1.1.1.1"),
 * 				},
 * 				{
 * 					Action: pulumi.String("Allow"),
 * 					IpMask: pulumi.String("1.1.1.2"),
 * 				},
 * 				{
 * 					Action: pulumi.String("Allow"),
 * 					IpMask: pulumi.String("1.1.1.3"),
 * 				},
 * 				{
 * 					Action: pulumi.String("Allow"),
 * 					IpMask: pulumi.String("1.1.1.4"),
 * 				},
 * 				{
 * 					Action: pulumi.String("Allow"),
 * 					IpMask: pulumi.String("1.1.1.5"),
 * 				},
 * 			},
 * 			NamespaceName:     pulumi.String("sdk-Namespace-6019"),
 * 			ResourceGroupName: pulumi.String("ResourceGroup"),
 * 			VirtualNetworkRules: []eventhub.NWRuleSetVirtualNetworkRulesArgs{
 * 				{
 * 					IgnoreMissingVnetServiceEndpoint: pulumi.Bool(true),
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2"),
 * 					},
 * 				},
 * 				{
 * 					IgnoreMissingVnetServiceEndpoint: pulumi.Bool(false),
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3"),
 * 					},
 * 				},
 * 				{
 * 					IgnoreMissingVnetServiceEndpoint: pulumi.Bool(false),
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventhub.NamespaceNetworkRuleSet;
 * import com.pulumi.azurenative.eventhub.NamespaceNetworkRuleSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceNetworkRuleSet = new NamespaceNetworkRuleSet("namespaceNetworkRuleSet", NamespaceNetworkRuleSetArgs.builder()
 *             .defaultAction("Deny")
 *             .ipRules(
 *                 Map.ofEntries(
 *                     Map.entry("action", "Allow"),
 *                     Map.entry("ipMask", "1.1.1.1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("action", "Allow"),
 *                     Map.entry("ipMask", "1.1.1.2")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("action", "Allow"),
 *                     Map.entry("ipMask", "1.1.1.3")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("action", "Allow"),
 *                     Map.entry("ipMask", "1.1.1.4")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("action", "Allow"),
 *                     Map.entry("ipMask", "1.1.1.5")
 *                 ))
 *             .namespaceName("sdk-Namespace-6019")
 *             .resourceGroupName("ResourceGroup")
 *             .virtualNetworkRules(
 *                 Map.ofEntries(
 *                     Map.entry("ignoreMissingVnetServiceEndpoint", true),
 *                     Map.entry("subnet", Map.of("id", "/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2"))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("ignoreMissingVnetServiceEndpoint", false),
 *                     Map.entry("subnet", Map.of("id", "/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3"))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("ignoreMissingVnetServiceEndpoint", false),
 *                     Map.entry("subnet", Map.of("id", "/subscriptions/subscriptionid/resourcegroups/resourcegroupid/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6"))
 *                 ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventhub:NamespaceNetworkRuleSet default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventHub/namespaces/{namespaceName}/networkRuleSets/default
 * ```
 * @property defaultAction Default Action for Network Rule Set
 * @property ipRules List of IpRules
 * @property namespaceName The Namespace name
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled. If value is SecuredByPerimeter then Inbound and Outbound communication is controlled by the network security perimeter and profile's access rules.
 * @property resourceGroupName Name of the resource group within the azure subscription.
 * @property trustedServiceAccessEnabled Value that indicates whether Trusted Service Access is Enabled or not.
 * @property virtualNetworkRules List VirtualNetwork Rules
 */
public data class NamespaceNetworkRuleSetArgs(
    public val defaultAction: Output<Either<String, DefaultAction>>? = null,
    public val ipRules: Output<List<NWRuleSetIpRulesArgs>>? = null,
    public val namespaceName: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccessFlag>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val trustedServiceAccessEnabled: Output<Boolean>? = null,
    public val virtualNetworkRules: Output<List<NWRuleSetVirtualNetworkRulesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.NamespaceNetworkRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.NamespaceNetworkRuleSetArgs =
        com.pulumi.azurenative.eventhub.NamespaceNetworkRuleSetArgs.builder()
            .defaultAction(
                defaultAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipRules(
                ipRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .trustedServiceAccessEnabled(trustedServiceAccessEnabled?.applyValue({ args0 -> args0 }))
            .virtualNetworkRules(
                virtualNetworkRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NamespaceNetworkRuleSetArgs].
 */
@PulumiTagMarker
public class NamespaceNetworkRuleSetArgsBuilder internal constructor() {
    private var defaultAction: Output<Either<String, DefaultAction>>? = null

    private var ipRules: Output<List<NWRuleSetIpRulesArgs>>? = null

    private var namespaceName: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccessFlag>>? = null

    private var resourceGroupName: Output<String>? = null

    private var trustedServiceAccessEnabled: Output<Boolean>? = null

    private var virtualNetworkRules: Output<List<NWRuleSetVirtualNetworkRulesArgs>>? = null

    /**
     * @param value Default Action for Network Rule Set
     */
    @JvmName("xjjvtyebiyluxjdl")
    public suspend fun defaultAction(`value`: Output<Either<String, DefaultAction>>) {
        this.defaultAction = value
    }

    /**
     * @param value List of IpRules
     */
    @JvmName("ngguiklekicruvcm")
    public suspend fun ipRules(`value`: Output<List<NWRuleSetIpRulesArgs>>) {
        this.ipRules = value
    }

    @JvmName("dfiysrsyqjetrpfw")
    public suspend fun ipRules(vararg values: Output<NWRuleSetIpRulesArgs>) {
        this.ipRules = Output.all(values.asList())
    }

    /**
     * @param values List of IpRules
     */
    @JvmName("lbmaunourxwvfcfj")
    public suspend fun ipRules(values: List<Output<NWRuleSetIpRulesArgs>>) {
        this.ipRules = Output.all(values)
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("cfckifvjnegyqbre")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled. If value is SecuredByPerimeter then Inbound and Outbound communication is controlled by the network security perimeter and profile's access rules.
     */
    @JvmName("jfanyeycgetelcqv")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccessFlag>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("dnkaamxejjcpqnhg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Value that indicates whether Trusted Service Access is Enabled or not.
     */
    @JvmName("tqhnfwktkwpgeksb")
    public suspend fun trustedServiceAccessEnabled(`value`: Output<Boolean>) {
        this.trustedServiceAccessEnabled = value
    }

    /**
     * @param value List VirtualNetwork Rules
     */
    @JvmName("xstlckscrhucpeky")
    public suspend fun virtualNetworkRules(`value`: Output<List<NWRuleSetVirtualNetworkRulesArgs>>) {
        this.virtualNetworkRules = value
    }

    @JvmName("wmykycuqjndrgabd")
    public suspend fun virtualNetworkRules(vararg values: Output<NWRuleSetVirtualNetworkRulesArgs>) {
        this.virtualNetworkRules = Output.all(values.asList())
    }

    /**
     * @param values List VirtualNetwork Rules
     */
    @JvmName("treurkddvhxkggve")
    public suspend fun virtualNetworkRules(values: List<Output<NWRuleSetVirtualNetworkRulesArgs>>) {
        this.virtualNetworkRules = Output.all(values)
    }

    /**
     * @param value Default Action for Network Rule Set
     */
    @JvmName("lpkyuvbhvbcbidpl")
    public suspend fun defaultAction(`value`: Either<String, DefaultAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value Default Action for Network Rule Set
     */
    @JvmName("mqcbbmbcndurhjft")
    public fun defaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value Default Action for Network Rule Set
     */
    @JvmName("ycqhvvmywcemekkx")
    public fun defaultAction(`value`: DefaultAction) {
        val toBeMapped = Either.ofRight<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value List of IpRules
     */
    @JvmName("menxespklbwbgryb")
    public suspend fun ipRules(`value`: List<NWRuleSetIpRulesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param argument List of IpRules
     */
    @JvmName("jvemjsismekbyhfa")
    public suspend fun ipRules(argument: List<suspend NWRuleSetIpRulesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NWRuleSetIpRulesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument List of IpRules
     */
    @JvmName("rhrsjxijiuygpmev")
    public suspend fun ipRules(vararg argument: suspend NWRuleSetIpRulesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NWRuleSetIpRulesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument List of IpRules
     */
    @JvmName("coxrbtxikyvvemui")
    public suspend fun ipRules(argument: suspend NWRuleSetIpRulesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NWRuleSetIpRulesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param values List of IpRules
     */
    @JvmName("odndgdkssamvjikd")
    public suspend fun ipRules(vararg values: NWRuleSetIpRulesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param value The Namespace name
     */
    @JvmName("baelfvcgusqipoks")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled. If value is SecuredByPerimeter then Inbound and Outbound communication is controlled by the network security perimeter and profile's access rules.
     */
    @JvmName("xfdfdgdfoagcwrgr")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccessFlag>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled. If value is SecuredByPerimeter then Inbound and Outbound communication is controlled by the network security perimeter and profile's access rules.
     */
    @JvmName("gwmepqvxyhqlsumu")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccessFlag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value This determines if traffic is allowed over public network. By default it is enabled. If value is SecuredByPerimeter then Inbound and Outbound communication is controlled by the network security perimeter and profile's access rules.
     */
    @JvmName("qjtgebffnrbfshxo")
    public fun publicNetworkAccess(`value`: PublicNetworkAccessFlag) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccessFlag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Name of the resource group within the azure subscription.
     */
    @JvmName("cdrjgfdwbavwjypy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Value that indicates whether Trusted Service Access is Enabled or not.
     */
    @JvmName("aygjlrdgdonhvyjw")
    public suspend fun trustedServiceAccessEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedServiceAccessEnabled = mapped
    }

    /**
     * @param value List VirtualNetwork Rules
     */
    @JvmName("kkbiumxnlbejclnx")
    public suspend fun virtualNetworkRules(`value`: List<NWRuleSetVirtualNetworkRulesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument List VirtualNetwork Rules
     */
    @JvmName("xqotojqdejnsoimt")
    public suspend
    fun virtualNetworkRules(argument: List<suspend NWRuleSetVirtualNetworkRulesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NWRuleSetVirtualNetworkRulesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument List VirtualNetwork Rules
     */
    @JvmName("hfgscsnmxfkautkr")
    public suspend fun virtualNetworkRules(
        vararg
        argument: suspend NWRuleSetVirtualNetworkRulesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NWRuleSetVirtualNetworkRulesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument List VirtualNetwork Rules
     */
    @JvmName("ejfevskafnkwlcre")
    public suspend
    fun virtualNetworkRules(argument: suspend NWRuleSetVirtualNetworkRulesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NWRuleSetVirtualNetworkRulesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param values List VirtualNetwork Rules
     */
    @JvmName("ptarnxfefmkcafsj")
    public suspend fun virtualNetworkRules(vararg values: NWRuleSetVirtualNetworkRulesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    internal fun build(): NamespaceNetworkRuleSetArgs = NamespaceNetworkRuleSetArgs(
        defaultAction = defaultAction,
        ipRules = ipRules,
        namespaceName = namespaceName,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        trustedServiceAccessEnabled = trustedServiceAccessEnabled,
        virtualNetworkRules = virtualNetworkRules,
    )
}
