@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This determines if traffic is allowed over public network. By default it is enabled. If value is SecuredByPerimeter then Inbound and Outbound communication is controlled by the network security perimeter and profile's access rules.
 */
public enum class PublicNetworkAccessFlag(
    public val javaValue: com.pulumi.azurenative.eventhub.enums.PublicNetworkAccessFlag,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.enums.PublicNetworkAccessFlag> {
    Enabled(com.pulumi.azurenative.eventhub.enums.PublicNetworkAccessFlag.Enabled),
    Disabled(com.pulumi.azurenative.eventhub.enums.PublicNetworkAccessFlag.Disabled),
    SecuredByPerimeter(com.pulumi.azurenative.eventhub.enums.PublicNetworkAccessFlag.SecuredByPerimeter),
    ;

    override fun toJava(): com.pulumi.azurenative.eventhub.enums.PublicNetworkAccessFlag = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.eventhub.enums.PublicNetworkAccessFlag):
            PublicNetworkAccessFlag =
            PublicNetworkAccessFlag.values().first { it.javaValue == javaType }
    }
}
