@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.ClusterSkuArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.ClusterSkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU parameters particular to a cluster instance.
 * @property capacity The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
 * @property name Name of this SKU.
 */
public data class ClusterSkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<Either<String, ClusterSkuName>>,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.ClusterSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.ClusterSkuArgs =
        com.pulumi.azurenative.eventhub.inputs.ClusterSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterSkuArgs].
 */
@PulumiTagMarker
public class ClusterSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<Either<String, ClusterSkuName>>? = null

    /**
     * @param value The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
     */
    @JvmName("ucnuhthvevwgicpp")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Name of this SKU.
     */
    @JvmName("iowhwueetlpyjnrx")
    public suspend fun name(`value`: Output<Either<String, ClusterSkuName>>) {
        this.name = value
    }

    /**
     * @param value The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
     */
    @JvmName("nrsxjyaxxyjnlvko")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Name of this SKU.
     */
    @JvmName("inuuvoxbkdpnpvrh")
    public suspend fun name(`value`: Either<String, ClusterSkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of this SKU.
     */
    @JvmName("pafarhcyggodicho")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClusterSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of this SKU.
     */
    @JvmName("ogkwrihtvkevteth")
    public fun name(`value`: ClusterSkuName) {
        val toBeMapped = Either.ofRight<String, ClusterSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ClusterSkuArgs = ClusterSkuArgs(
        capacity = capacity,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
