@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventhub.kotlin.inputs

import com.pulumi.azurenative.eventhub.inputs.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.eventhub.kotlin.enums.EndPointProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of the PrivateEndpointConnection.
 * @property privateEndpoint The Private Endpoint resource for this Connection.
 * @property privateLinkServiceConnectionState Details about the state of the connection.
 * @property provisioningState Provisioning state of the Private Endpoint Connection.
 */
public data class PrivateEndpointConnectionArgs(
    public val privateEndpoint: Output<PrivateEndpointArgs>? = null,
    public val privateLinkServiceConnectionState: Output<ConnectionStateArgs>? = null,
    public val provisioningState: Output<Either<String, EndPointProvisioningState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventhub.inputs.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.eventhub.inputs.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.eventhub.inputs.PrivateEndpointConnectionArgs.builder()
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var privateEndpoint: Output<PrivateEndpointArgs>? = null

    private var privateLinkServiceConnectionState: Output<ConnectionStateArgs>? = null

    private var provisioningState: Output<Either<String, EndPointProvisioningState>>? = null

    /**
     * @param value The Private Endpoint resource for this Connection.
     */
    @JvmName("thsaorcycfhxgffq")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value Details about the state of the connection.
     */
    @JvmName("jtmbfjtwkmtusqcj")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<ConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("yrgjjvmgebothiqv")
    public suspend fun provisioningState(`value`: Output<Either<String, EndPointProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The Private Endpoint resource for this Connection.
     */
    @JvmName("mkemreeacymwporv")
    public suspend fun privateEndpoint(`value`: PrivateEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument The Private Endpoint resource for this Connection.
     */
    @JvmName("ngmjracirlxkyion")
    public suspend fun privateEndpoint(argument: suspend PrivateEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value Details about the state of the connection.
     */
    @JvmName("vtexeehvaqosouoh")
    public suspend fun privateLinkServiceConnectionState(`value`: ConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Details about the state of the connection.
     */
    @JvmName("etanviuslcmygvgr")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend ConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("hfgqgxikjdpmbbnx")
    public suspend fun provisioningState(`value`: Either<String, EndPointProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("dyuwgoxggxqxtmvk")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EndPointProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("wjwumljejiqdgomx")
    public fun provisioningState(`value`: EndPointProvisioningState) {
        val toBeMapped = Either.ofRight<String, EndPointProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        privateEndpoint = privateEndpoint,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        provisioningState = provisioningState,
    )
}
