@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.extendedlocation.kotlin

import com.pulumi.azurenative.extendedlocation.ResourceSyncRuleArgs.builder
import com.pulumi.azurenative.extendedlocation.kotlin.inputs.ResourceSyncRulePropertiesSelectorArgs
import com.pulumi.azurenative.extendedlocation.kotlin.inputs.ResourceSyncRulePropertiesSelectorArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource Sync Rules definition.
 * Azure REST API version: 2021-08-31-preview. Prior API version in Azure Native 1.x: 2021-08-31-preview.
 * ## Example Usage
 * ### Create/Update Resource Sync Rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var resourceSyncRule = new AzureNative.ExtendedLocation.ResourceSyncRule("resourceSyncRule", new()
 *     {
 *         ChildResourceName = "resourceSyncRule01",
 *         Location = "West US",
 *         Priority = 999,
 *         ResourceGroupName = "testresourcegroup",
 *         ResourceName = "customLocation01",
 *         Selector = new AzureNative.ExtendedLocation.Inputs.ResourceSyncRulePropertiesSelectorArgs
 *         {
 *             MatchLabels =
 *             {
 *                 { "key1", "value1" },
 *             },
 *         },
 *         TargetResourceGroup = "/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/testresourcegroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/extendedlocation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := extendedlocation.NewResourceSyncRule(ctx, "resourceSyncRule", &extendedlocation.ResourceSyncRuleArgs{
 * 			ChildResourceName: pulumi.String("resourceSyncRule01"),
 * 			Location:          pulumi.String("West US"),
 * 			Priority:          pulumi.Int(999),
 * 			ResourceGroupName: pulumi.String("testresourcegroup"),
 * 			ResourceName:      pulumi.String("customLocation01"),
 * 			Selector: &extendedlocation.ResourceSyncRulePropertiesSelectorArgs{
 * 				MatchLabels: pulumi.StringMap{
 * 					"key1": pulumi.String("value1"),
 * 				},
 * 			},
 * 			TargetResourceGroup: pulumi.String("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/testresourcegroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.extendedlocation.ResourceSyncRule;
 * import com.pulumi.azurenative.extendedlocation.ResourceSyncRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var resourceSyncRule = new ResourceSyncRule("resourceSyncRule", ResourceSyncRuleArgs.builder()
 *             .childResourceName("resourceSyncRule01")
 *             .location("West US")
 *             .priority(999)
 *             .resourceGroupName("testresourcegroup")
 *             .resourceName("customLocation01")
 *             .selector(Map.of("matchLabels", Map.of("key1", "value1")))
 *             .targetResourceGroup("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/testresourcegroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:extendedlocation:ResourceSyncRule resourceSyncRule01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ExtendedLocation/customLocations/{resourceName}/resourceSyncRules/{childResourceName}
 * ```
 * @property childResourceName Resource Sync Rule name.
 * @property location The geo-location where the resource lives
 * @property priority Priority represents a priority of the Resource Sync Rule
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName Custom Locations name.
 * @property selector A label selector is composed of two parts, matchLabels and matchExpressions. The first part, matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is 'key', the operator is 'In', and the values array contains only 'value'. The second part, matchExpressions is a list of resource selector requirements. Valid operators include In, NotIn, Exists, and DoesNotExist. The values set must be non-empty in the case of In and NotIn. The values set must be empty in the case of Exists and DoesNotExist. All of the requirements, from both matchLabels and matchExpressions must all be satisfied in order to match.
 * @property tags Resource tags.
 * @property targetResourceGroup For an unmapped custom resource, its labels will be used to find matching resource sync rules. If this resource sync rule is one of the matching rules with highest priority, then the unmapped custom resource will be projected to the target resource group associated with this resource sync rule. The user creating this resource sync rule should have write permissions on the target resource group and this write permission will be validated when creating the resource sync rule.
 */
public data class ResourceSyncRuleArgs(
    public val childResourceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val selector: Output<ResourceSyncRulePropertiesSelectorArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceGroup: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.extendedlocation.ResourceSyncRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.extendedlocation.ResourceSyncRuleArgs =
        com.pulumi.azurenative.extendedlocation.ResourceSyncRuleArgs.builder()
            .childResourceName(childResourceName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .selector(selector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceGroup(targetResourceGroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceSyncRuleArgs].
 */
@PulumiTagMarker
public class ResourceSyncRuleArgsBuilder internal constructor() {
    private var childResourceName: Output<String>? = null

    private var location: Output<String>? = null

    private var priority: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var selector: Output<ResourceSyncRulePropertiesSelectorArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceGroup: Output<String>? = null

    /**
     * @param value Resource Sync Rule name.
     */
    @JvmName("ntnhgqehfqsiyfnl")
    public suspend fun childResourceName(`value`: Output<String>) {
        this.childResourceName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("chfqugxqjdxgyusv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Priority represents a priority of the Resource Sync Rule
     */
    @JvmName("hrxmiohjmyxbxsox")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ocqisxufpnlonnkh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Custom Locations name.
     */
    @JvmName("eufxadsppayvkfkn")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value A label selector is composed of two parts, matchLabels and matchExpressions. The first part, matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is 'key', the operator is 'In', and the values array contains only 'value'. The second part, matchExpressions is a list of resource selector requirements. Valid operators include In, NotIn, Exists, and DoesNotExist. The values set must be non-empty in the case of In and NotIn. The values set must be empty in the case of Exists and DoesNotExist. All of the requirements, from both matchLabels and matchExpressions must all be satisfied in order to match.
     */
    @JvmName("vnyaqsekcnwmwuvg")
    public suspend fun selector(`value`: Output<ResourceSyncRulePropertiesSelectorArgs>) {
        this.selector = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ihiospneeeeoflru")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value For an unmapped custom resource, its labels will be used to find matching resource sync rules. If this resource sync rule is one of the matching rules with highest priority, then the unmapped custom resource will be projected to the target resource group associated with this resource sync rule. The user creating this resource sync rule should have write permissions on the target resource group and this write permission will be validated when creating the resource sync rule.
     */
    @JvmName("djuoobyvvuihrcat")
    public suspend fun targetResourceGroup(`value`: Output<String>) {
        this.targetResourceGroup = value
    }

    /**
     * @param value Resource Sync Rule name.
     */
    @JvmName("ihsjvjhwgwgomwwi")
    public suspend fun childResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.childResourceName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lmkleclqlyaovrbt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Priority represents a priority of the Resource Sync Rule
     */
    @JvmName("ofswcjprdgyatdlx")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pknkywnrfqvwlgen")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Custom Locations name.
     */
    @JvmName("btoenrlmfxoyyjpe")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value A label selector is composed of two parts, matchLabels and matchExpressions. The first part, matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is 'key', the operator is 'In', and the values array contains only 'value'. The second part, matchExpressions is a list of resource selector requirements. Valid operators include In, NotIn, Exists, and DoesNotExist. The values set must be non-empty in the case of In and NotIn. The values set must be empty in the case of Exists and DoesNotExist. All of the requirements, from both matchLabels and matchExpressions must all be satisfied in order to match.
     */
    @JvmName("qbqnaoowhjvnphiq")
    public suspend fun selector(`value`: ResourceSyncRulePropertiesSelectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selector = mapped
    }

    /**
     * @param argument A label selector is composed of two parts, matchLabels and matchExpressions. The first part, matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is 'key', the operator is 'In', and the values array contains only 'value'. The second part, matchExpressions is a list of resource selector requirements. Valid operators include In, NotIn, Exists, and DoesNotExist. The values set must be non-empty in the case of In and NotIn. The values set must be empty in the case of Exists and DoesNotExist. All of the requirements, from both matchLabels and matchExpressions must all be satisfied in order to match.
     */
    @JvmName("kpcdpwervbyvylbf")
    public suspend
    fun selector(argument: suspend ResourceSyncRulePropertiesSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSyncRulePropertiesSelectorArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.selector = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("shpagtdkpdfpktdk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ioegbbjfgujtmudp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value For an unmapped custom resource, its labels will be used to find matching resource sync rules. If this resource sync rule is one of the matching rules with highest priority, then the unmapped custom resource will be projected to the target resource group associated with this resource sync rule. The user creating this resource sync rule should have write permissions on the target resource group and this write permission will be validated when creating the resource sync rule.
     */
    @JvmName("ychvbvlwwekhjuwu")
    public suspend fun targetResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceGroup = mapped
    }

    internal fun build(): ResourceSyncRuleArgs = ResourceSyncRuleArgs(
        childResourceName = childResourceName,
        location = location,
        priority = priority,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        selector = selector,
        tags = tags,
        targetResourceGroup = targetResourceGroup,
    )
}
