@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.extendedlocation.kotlin.inputs

import com.pulumi.azurenative.extendedlocation.inputs.IdentityArgs.builder
import com.pulumi.azurenative.extendedlocation.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity for the resource.
 * @property type The identity type.
 */
public data class IdentityArgs(
    public val type: Output<Either<String, ResourceIdentityType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.extendedlocation.inputs.IdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.extendedlocation.inputs.IdentityArgs =
        com.pulumi.azurenative.extendedlocation.inputs.IdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentityArgs].
 */
@PulumiTagMarker
public class IdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, ResourceIdentityType>>? = null

    /**
     * @param value The identity type.
     */
    @JvmName("jgvrbluhxlnxrkie")
    public suspend fun type(`value`: Output<Either<String, ResourceIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The identity type.
     */
    @JvmName("tojiiajlkkfokkgl")
    public suspend fun type(`value`: Either<String, ResourceIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The identity type.
     */
    @JvmName("smunhhsgbavaduho")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The identity type.
     */
    @JvmName("wifpdxrhsmofxuvf")
    public fun type(`value`: ResourceIdentityType) {
        val toBeMapped = Either.ofRight<String, ResourceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IdentityArgs = IdentityArgs(
        type = type,
    )
}
