@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.extendedlocation.kotlin.inputs

import com.pulumi.azurenative.extendedlocation.inputs.ResourceSyncRulePropertiesSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A label selector is composed of two parts, matchLabels and matchExpressions. The first part, matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is 'key', the operator is 'In', and the values array contains only 'value'. The second part, matchExpressions is a list of resource selector requirements. Valid operators include In, NotIn, Exists, and DoesNotExist. The values set must be non-empty in the case of In and NotIn. The values set must be empty in the case of Exists and DoesNotExist. All of the requirements, from both matchLabels and matchExpressions must all be satisfied in order to match.
 * @property matchLabels MatchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is 'key', the operator is 'In', and the values array contains only 'value'.
 */
public data class ResourceSyncRulePropertiesSelectorArgs(
    public val matchLabels: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.extendedlocation.inputs.ResourceSyncRulePropertiesSelectorArgs> {
    override fun toJava():
        com.pulumi.azurenative.extendedlocation.inputs.ResourceSyncRulePropertiesSelectorArgs =
        com.pulumi.azurenative.extendedlocation.inputs.ResourceSyncRulePropertiesSelectorArgs.builder()
            .matchLabels(
                matchLabels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResourceSyncRulePropertiesSelectorArgs].
 */
@PulumiTagMarker
public class ResourceSyncRulePropertiesSelectorArgsBuilder internal constructor() {
    private var matchLabels: Output<Map<String, String>>? = null

    /**
     * @param value MatchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is 'key', the operator is 'In', and the values array contains only 'value'.
     */
    @JvmName("gfyvmvphwaqlapky")
    public suspend fun matchLabels(`value`: Output<Map<String, String>>) {
        this.matchLabels = value
    }

    /**
     * @param value MatchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is 'key', the operator is 'In', and the values array contains only 'value'.
     */
    @JvmName("yddeluwghlsiptcl")
    public suspend fun matchLabels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchLabels = mapped
    }

    /**
     * @param values MatchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is 'key', the operator is 'In', and the values array contains only 'value'.
     */
    @JvmName("apolrhprocsooves")
    public fun matchLabels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchLabels = mapped
    }

    internal fun build(): ResourceSyncRulePropertiesSelectorArgs =
        ResourceSyncRulePropertiesSelectorArgs(
            matchLabels = matchLabels,
        )
}
