@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.extendedlocation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Custom Locations definition.
 * @property authentication This is optional input that contains the authentication that should be used to generate the namespace.
 * @property clusterExtensionIds Contains the reference to the add-on that contains charts to deploy CRDs and operators.
 * @property displayName Display name for the Custom Locations location.
 * @property hostResourceId Connected Cluster or AKS Cluster. The Custom Locations RP will perform a checkAccess API for listAdminCredentials permissions.
 * @property hostType Type of host the Custom Locations is referencing (Kubernetes, etc...).
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Identity for the resource.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property namespace Kubernetes namespace that will be created on the specified cluster.
 * @property provisioningState Provisioning State for the Custom Location.
 * @property systemData Metadata pertaining to creation and last modification of the resource
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetCustomLocationResult(
    public val authentication: CustomLocationPropertiesResponseAuthentication? = null,
    public val clusterExtensionIds: List<String>? = null,
    public val displayName: String? = null,
    public val hostResourceId: String? = null,
    public val hostType: String? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val location: String,
    public val name: String,
    public val namespace: String? = null,
    public val provisioningState: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.extendedlocation.outputs.GetCustomLocationResult):
            GetCustomLocationResult = GetCustomLocationResult(
            authentication = javaType.authentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.extendedlocation.kotlin.outputs.CustomLocationPropertiesResponseAuthentication.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clusterExtensionIds = javaType.clusterExtensionIds().map({ args0 -> args0 }),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            hostResourceId = javaType.hostResourceId().map({ args0 -> args0 }).orElse(null),
            hostType = javaType.hostType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.extendedlocation.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.extendedlocation.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
