@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.fluidrelay.kotlin

import com.pulumi.azurenative.fluidrelay.FluidrelayFunctions.getFluidRelayServerPlain
import com.pulumi.azurenative.fluidrelay.FluidrelayFunctions.listFluidRelayServerKeysPlain
import com.pulumi.azurenative.fluidrelay.kotlin.inputs.GetFluidRelayServerPlainArgs
import com.pulumi.azurenative.fluidrelay.kotlin.inputs.GetFluidRelayServerPlainArgsBuilder
import com.pulumi.azurenative.fluidrelay.kotlin.inputs.ListFluidRelayServerKeysPlainArgs
import com.pulumi.azurenative.fluidrelay.kotlin.inputs.ListFluidRelayServerKeysPlainArgsBuilder
import com.pulumi.azurenative.fluidrelay.kotlin.outputs.GetFluidRelayServerResult
import com.pulumi.azurenative.fluidrelay.kotlin.outputs.ListFluidRelayServerKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.fluidrelay.kotlin.outputs.GetFluidRelayServerResult.Companion.toKotlin as getFluidRelayServerResultToKotlin
import com.pulumi.azurenative.fluidrelay.kotlin.outputs.ListFluidRelayServerKeysResult.Companion.toKotlin as listFluidRelayServerKeysResultToKotlin

public object FluidrelayFunctions {
    /**
     * A FluidRelay Server.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2021-06-15-preview.
     * @param argument null
     * @return A FluidRelay Server.
     */
    public suspend fun getFluidRelayServer(argument: GetFluidRelayServerPlainArgs):
        GetFluidRelayServerResult =
        getFluidRelayServerResultToKotlin(getFluidRelayServerPlain(argument.toJava()).await())

    /**
     * @see [getFluidRelayServer].
     * @param fluidRelayServerName The Fluid Relay server resource name.
     * @param resourceGroup The resource group containing the resource.
     * @return A FluidRelay Server.
     */
    public suspend fun getFluidRelayServer(fluidRelayServerName: String, resourceGroup: String):
        GetFluidRelayServerResult {
        val argument = GetFluidRelayServerPlainArgs(
            fluidRelayServerName = fluidRelayServerName,
            resourceGroup = resourceGroup,
        )
        return getFluidRelayServerResultToKotlin(getFluidRelayServerPlain(argument.toJava()).await())
    }

    /**
     * @see [getFluidRelayServer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;fluidrelay&#46;kotlin&#46;inputs&#46;GetFluidRelayServerPlainArgs].
     * @return A FluidRelay Server.
     */
    public suspend
    fun getFluidRelayServer(argument: suspend GetFluidRelayServerPlainArgsBuilder.() -> Unit):
        GetFluidRelayServerResult {
        val builder = GetFluidRelayServerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFluidRelayServerResultToKotlin(getFluidRelayServerPlain(builtArgument.toJava()).await())
    }

    /**
     * The set of available keys for this server.
     * Azure REST API version: 2022-06-01.
     * @param argument null
     * @return The set of available keys for this server.
     */
    public suspend fun listFluidRelayServerKeys(argument: ListFluidRelayServerKeysPlainArgs):
        ListFluidRelayServerKeysResult =
        listFluidRelayServerKeysResultToKotlin(listFluidRelayServerKeysPlain(argument.toJava()).await())

    /**
     * @see [listFluidRelayServerKeys].
     * @param fluidRelayServerName The Fluid Relay server resource name.
     * @param resourceGroup The resource group containing the resource.
     * @return The set of available keys for this server.
     */
    public suspend fun listFluidRelayServerKeys(fluidRelayServerName: String, resourceGroup: String):
        ListFluidRelayServerKeysResult {
        val argument = ListFluidRelayServerKeysPlainArgs(
            fluidRelayServerName = fluidRelayServerName,
            resourceGroup = resourceGroup,
        )
        return listFluidRelayServerKeysResultToKotlin(listFluidRelayServerKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listFluidRelayServerKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;fluidrelay&#46;kotlin&#46;inputs&#46;ListFluidRelayServerKeysPlainArgs].
     * @return The set of available keys for this server.
     */
    public suspend
    fun listFluidRelayServerKeys(argument: suspend ListFluidRelayServerKeysPlainArgsBuilder.() -> Unit):
        ListFluidRelayServerKeysResult {
        val builder = ListFluidRelayServerKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listFluidRelayServerKeysResultToKotlin(listFluidRelayServerKeysPlain(builtArgument.toJava()).await())
    }
}
