@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.fluidrelay.kotlin.inputs

import com.pulumi.azurenative.fluidrelay.inputs.CustomerManagedKeyEncryptionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * All Customer-managed key encryption properties for the resource.
 * @property keyEncryptionKeyIdentity All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
 * @property keyEncryptionKeyUrl key encryption key Url, with or without a version. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or https://contosovault.vault.azure.net/keys/contosokek. Key auto rotation is enabled by providing a key uri without version. Otherwise, customer is responsible for rotating the key. The keyEncryptionKeyIdentity(either SystemAssigned or UserAssigned) should have permission to access this key url.
 */
public data class CustomerManagedKeyEncryptionPropertiesArgs(
    public val keyEncryptionKeyIdentity:
    Output<CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs>? = null,
    public val keyEncryptionKeyUrl: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.fluidrelay.inputs.CustomerManagedKeyEncryptionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.fluidrelay.inputs.CustomerManagedKeyEncryptionPropertiesArgs =
        com.pulumi.azurenative.fluidrelay.inputs.CustomerManagedKeyEncryptionPropertiesArgs.builder()
            .keyEncryptionKeyIdentity(
                keyEncryptionKeyIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .keyEncryptionKeyUrl(keyEncryptionKeyUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomerManagedKeyEncryptionPropertiesArgs].
 */
@PulumiTagMarker
public class CustomerManagedKeyEncryptionPropertiesArgsBuilder internal constructor() {
    private var keyEncryptionKeyIdentity:
        Output<CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs>? = null

    private var keyEncryptionKeyUrl: Output<String>? = null

    /**
     * @param value All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
     */
    @JvmName("glogbviycpmbbotn")
    public suspend
    fun keyEncryptionKeyIdentity(`value`: Output<CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs>) {
        this.keyEncryptionKeyIdentity = value
    }

    /**
     * @param value key encryption key Url, with or without a version. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or https://contosovault.vault.azure.net/keys/contosokek. Key auto rotation is enabled by providing a key uri without version. Otherwise, customer is responsible for rotating the key. The keyEncryptionKeyIdentity(either SystemAssigned or UserAssigned) should have permission to access this key url.
     */
    @JvmName("ufqukrmanmxkeikj")
    public suspend fun keyEncryptionKeyUrl(`value`: Output<String>) {
        this.keyEncryptionKeyUrl = value
    }

    /**
     * @param value All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
     */
    @JvmName("exwsypxktdkwkukv")
    public suspend
    fun keyEncryptionKeyIdentity(`value`: CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyEncryptionKeyIdentity = mapped
    }

    /**
     * @param argument All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
     */
    @JvmName("bekskqrwgilqcfve")
    public suspend
    fun keyEncryptionKeyIdentity(argument: suspend CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgsBuilder.() -> Unit) {
        val toBeMapped =
            CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.keyEncryptionKeyIdentity = mapped
    }

    /**
     * @param value key encryption key Url, with or without a version. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or https://contosovault.vault.azure.net/keys/contosokek. Key auto rotation is enabled by providing a key uri without version. Otherwise, customer is responsible for rotating the key. The keyEncryptionKeyIdentity(either SystemAssigned or UserAssigned) should have permission to access this key url.
     */
    @JvmName("rbclfntfncexuuqe")
    public suspend fun keyEncryptionKeyUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyEncryptionKeyUrl = mapped
    }

    internal fun build(): CustomerManagedKeyEncryptionPropertiesArgs =
        CustomerManagedKeyEncryptionPropertiesArgs(
            keyEncryptionKeyIdentity = keyEncryptionKeyIdentity,
            keyEncryptionKeyUrl = keyEncryptionKeyUrl,
        )
}
