@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.fluidrelay.kotlin.inputs

import com.pulumi.azurenative.fluidrelay.inputs.EncryptionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * All encryption configuration for a resource.
 * @property customerManagedKeyEncryption All Customer-managed key encryption properties for the resource.
 */
public data class EncryptionPropertiesArgs(
    public val customerManagedKeyEncryption: Output<CustomerManagedKeyEncryptionPropertiesArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.fluidrelay.inputs.EncryptionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.fluidrelay.inputs.EncryptionPropertiesArgs =
        com.pulumi.azurenative.fluidrelay.inputs.EncryptionPropertiesArgs.builder()
            .customerManagedKeyEncryption(
                customerManagedKeyEncryption?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [EncryptionPropertiesArgs].
 */
@PulumiTagMarker
public class EncryptionPropertiesArgsBuilder internal constructor() {
    private var customerManagedKeyEncryption: Output<CustomerManagedKeyEncryptionPropertiesArgs>? =
        null

    /**
     * @param value All Customer-managed key encryption properties for the resource.
     */
    @JvmName("wfrjealsljoynbvv")
    public suspend
    fun customerManagedKeyEncryption(`value`: Output<CustomerManagedKeyEncryptionPropertiesArgs>) {
        this.customerManagedKeyEncryption = value
    }

    /**
     * @param value All Customer-managed key encryption properties for the resource.
     */
    @JvmName("vvgqbnjbatxqyqls")
    public suspend
    fun customerManagedKeyEncryption(`value`: CustomerManagedKeyEncryptionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerManagedKeyEncryption = mapped
    }

    /**
     * @param argument All Customer-managed key encryption properties for the resource.
     */
    @JvmName("eijaqukwnyhuqjet")
    public suspend
    fun customerManagedKeyEncryption(argument: suspend CustomerManagedKeyEncryptionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CustomerManagedKeyEncryptionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customerManagedKeyEncryption = mapped
    }

    internal fun build(): EncryptionPropertiesArgs = EncryptionPropertiesArgs(
        customerManagedKeyEncryption = customerManagedKeyEncryption,
    )
}
