@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.fluidrelay.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * All Customer-managed key encryption properties for the resource.
 * @property keyEncryptionKeyIdentity All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
 * @property keyEncryptionKeyUrl key encryption key Url, with or without a version. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or https://contosovault.vault.azure.net/keys/contosokek. Key auto rotation is enabled by providing a key uri without version. Otherwise, customer is responsible for rotating the key. The keyEncryptionKeyIdentity(either SystemAssigned or UserAssigned) should have permission to access this key url.
 */
public data class CustomerManagedKeyEncryptionPropertiesResponse(
    public val keyEncryptionKeyIdentity:
    CustomerManagedKeyEncryptionPropertiesResponseKeyEncryptionKeyIdentity? = null,
    public val keyEncryptionKeyUrl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.fluidrelay.outputs.CustomerManagedKeyEncryptionPropertiesResponse):
            CustomerManagedKeyEncryptionPropertiesResponse =
            CustomerManagedKeyEncryptionPropertiesResponse(
                keyEncryptionKeyIdentity = javaType.keyEncryptionKeyIdentity().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.fluidrelay.kotlin.outputs.CustomerManagedKeyEncryptionPropertiesResponseKeyEncryptionKeyIdentity.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                keyEncryptionKeyUrl = javaType.keyEncryptionKeyUrl().map({ args0 -> args0 }).orElse(null),
            )
    }
}
