@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.graphservices.kotlin

import com.pulumi.azurenative.graphservices.GraphservicesFunctions.getAccountPlain
import com.pulumi.azurenative.graphservices.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.graphservices.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.graphservices.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.graphservices.kotlin.outputs.GetAccountResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object GraphservicesFunctions {
    /**
     * Returns account resource for a given name.
     * Azure REST API version: 2023-04-13.
     * @param argument null
     * @return Account details
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        toKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the resource.
     * @return Account details
     */
    public suspend fun getAccount(resourceGroupName: String, resourceName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return toKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;graphservices&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return Account details
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit):
        GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getAccountPlain(builtArgument.toJava()).await())
    }
}
