@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.graphservices.kotlin.inputs

import com.pulumi.azurenative.graphservices.inputs.AccountResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Property bag from billing account
 * @property appId Customer owned application ID
 */
public data class AccountResourcePropertiesArgs(
    public val appId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.graphservices.inputs.AccountResourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.graphservices.inputs.AccountResourcePropertiesArgs =
        com.pulumi.azurenative.graphservices.inputs.AccountResourcePropertiesArgs.builder()
            .appId(appId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountResourcePropertiesArgs].
 */
@PulumiTagMarker
public class AccountResourcePropertiesArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    /**
     * @param value Customer owned application ID
     */
    @JvmName("cldwsphlsljdbnpu")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Customer owned application ID
     */
    @JvmName("borjwjwfdtarhium")
    public suspend fun appId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    internal fun build(): AccountResourcePropertiesArgs = AccountResourcePropertiesArgs(
        appId = appId ?: throw PulumiNullFieldException("appId"),
    )
}
