@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hanaonazure.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProviderInstance].
 */
@PulumiTagMarker
public class ProviderInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProviderInstanceArgs = ProviderInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProviderInstanceArgsBuilder.() -> Unit) {
        val builder = ProviderInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProviderInstance {
        val builtJavaResource =
            com.pulumi.azurenative.hanaonazure.ProviderInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProviderInstance(builtJavaResource)
    }
}

/**
 * A provider instance associated with a SAP monitor.
 * Azure REST API version: 2020-02-07-preview. Prior API version in Azure Native 1.x: 2020-02-07-preview.
 * ## Example Usage
 * ### Create a SAP Monitor
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.HanaOnAzure.ProviderInstance("providerInstance", new()
 *     {
 *         Metadata = "{\"key\":\"value\"}",
 *         Properties = "{\"hostname\":\"10.0.0.6\",\"dbName\":\"SYSTEMDB\",\"sqlPort\":30013,\"dbUsername\":\"SYSTEM\",\"dbPassword\":\"PASSWORD\"}",
 *         ProviderInstanceName = "myProviderInstance",
 *         ResourceGroupName = "myResourceGroup",
 *         SapMonitorName = "mySapMonitor",
 *         Type = "hana",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hanaonazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hanaonazure.NewProviderInstance(ctx, "providerInstance", &hanaonazure.ProviderInstanceArgs{
 * 			Metadata:             pulumi.String("{\"key\":\"value\"}"),
 * 			Properties:           pulumi.String("{\"hostname\":\"10.0.0.6\",\"dbName\":\"SYSTEMDB\",\"sqlPort\":30013,\"dbUsername\":\"SYSTEM\",\"dbPassword\":\"PASSWORD\"}"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ResourceGroupName:    pulumi.String("myResourceGroup"),
 * 			SapMonitorName:       pulumi.String("mySapMonitor"),
 * 			Type:                 pulumi.String("hana"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hanaonazure.ProviderInstance;
 * import com.pulumi.azurenative.hanaonazure.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .metadata("{\"key\":\"value\"}")
 *             .properties("{\"hostname\":\"10.0.0.6\",\"dbName\":\"SYSTEMDB\",\"sqlPort\":30013,\"dbUsername\":\"SYSTEM\",\"dbPassword\":\"PASSWORD\"}")
 *             .providerInstanceName("myProviderInstance")
 *             .resourceGroupName("myResourceGroup")
 *             .sapMonitorName("mySapMonitor")
 *             .type("hana")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hanaonazure:ProviderInstance myProviderInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HanaOnAzure/sapMonitors/{sapMonitorName}/providerInstances/{providerInstanceName}
 * ```
 */
public class ProviderInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.hanaonazure.ProviderInstance,
) : KotlinCustomResource(javaResource, ProviderInstanceMapper) {
    /**
     * A JSON string containing metadata of the provider instance.
     */
    public val metadata: Output<String>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A JSON string containing the properties of the provider instance.
     */
    public val properties: Output<String>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * State of provisioning of the provider instance
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProviderInstanceMapper : ResourceMapper<ProviderInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hanaonazure.ProviderInstance::class == javaResource::class

    override fun map(javaResource: Resource): ProviderInstance = ProviderInstance(
        javaResource as
            com.pulumi.azurenative.hanaonazure.ProviderInstance,
    )
}

/**
 * @see [ProviderInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProviderInstance].
 */
public suspend fun providerInstance(
    name: String,
    block: suspend ProviderInstanceResourceBuilder.() -> Unit,
): ProviderInstance {
    val builder = ProviderInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProviderInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun providerInstance(name: String): ProviderInstance {
    val builder = ProviderInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
