@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hanaonazure.kotlin

import com.pulumi.azurenative.hanaonazure.ProviderInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A provider instance associated with a SAP monitor.
 * Azure REST API version: 2020-02-07-preview. Prior API version in Azure Native 1.x: 2020-02-07-preview.
 * ## Example Usage
 * ### Create a SAP Monitor
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var providerInstance = new AzureNative.HanaOnAzure.ProviderInstance("providerInstance", new()
 *     {
 *         Metadata = "{\"key\":\"value\"}",
 *         Properties = "{\"hostname\":\"10.0.0.6\",\"dbName\":\"SYSTEMDB\",\"sqlPort\":30013,\"dbUsername\":\"SYSTEM\",\"dbPassword\":\"PASSWORD\"}",
 *         ProviderInstanceName = "myProviderInstance",
 *         ResourceGroupName = "myResourceGroup",
 *         SapMonitorName = "mySapMonitor",
 *         Type = "hana",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hanaonazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hanaonazure.NewProviderInstance(ctx, "providerInstance", &hanaonazure.ProviderInstanceArgs{
 * 			Metadata:             pulumi.String("{\"key\":\"value\"}"),
 * 			Properties:           pulumi.String("{\"hostname\":\"10.0.0.6\",\"dbName\":\"SYSTEMDB\",\"sqlPort\":30013,\"dbUsername\":\"SYSTEM\",\"dbPassword\":\"PASSWORD\"}"),
 * 			ProviderInstanceName: pulumi.String("myProviderInstance"),
 * 			ResourceGroupName:    pulumi.String("myResourceGroup"),
 * 			SapMonitorName:       pulumi.String("mySapMonitor"),
 * 			Type:                 pulumi.String("hana"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hanaonazure.ProviderInstance;
 * import com.pulumi.azurenative.hanaonazure.ProviderInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var providerInstance = new ProviderInstance("providerInstance", ProviderInstanceArgs.builder()
 *             .metadata("{\"key\":\"value\"}")
 *             .properties("{\"hostname\":\"10.0.0.6\",\"dbName\":\"SYSTEMDB\",\"sqlPort\":30013,\"dbUsername\":\"SYSTEM\",\"dbPassword\":\"PASSWORD\"}")
 *             .providerInstanceName("myProviderInstance")
 *             .resourceGroupName("myResourceGroup")
 *             .sapMonitorName("mySapMonitor")
 *             .type("hana")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hanaonazure:ProviderInstance myProviderInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HanaOnAzure/sapMonitors/{sapMonitorName}/providerInstances/{providerInstanceName}
 * ```
 * @property metadata A JSON string containing metadata of the provider instance.
 * @property properties A JSON string containing the properties of the provider instance.
 * @property providerInstanceName Name of the provider instance.
 * @property resourceGroupName Name of the resource group.
 * @property sapMonitorName Name of the SAP monitor resource.
 * @property type The type of provider instance.
 */
public data class ProviderInstanceArgs(
    public val metadata: Output<String>? = null,
    public val properties: Output<String>? = null,
    public val providerInstanceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sapMonitorName: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hanaonazure.ProviderInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.hanaonazure.ProviderInstanceArgs =
        com.pulumi.azurenative.hanaonazure.ProviderInstanceArgs.builder()
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .providerInstanceName(providerInstanceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sapMonitorName(sapMonitorName?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProviderInstanceArgs].
 */
@PulumiTagMarker
public class ProviderInstanceArgsBuilder internal constructor() {
    private var metadata: Output<String>? = null

    private var properties: Output<String>? = null

    private var providerInstanceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sapMonitorName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value A JSON string containing metadata of the provider instance.
     */
    @JvmName("alivefxhliopjboc")
    public suspend fun metadata(`value`: Output<String>) {
        this.metadata = value
    }

    /**
     * @param value A JSON string containing the properties of the provider instance.
     */
    @JvmName("yiuiqfbhuajextjc")
    public suspend fun properties(`value`: Output<String>) {
        this.properties = value
    }

    /**
     * @param value Name of the provider instance.
     */
    @JvmName("qfarnpfnyhnnkedk")
    public suspend fun providerInstanceName(`value`: Output<String>) {
        this.providerInstanceName = value
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("vbowetqwwrlranyi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the SAP monitor resource.
     */
    @JvmName("drrlmsdlmvvsvtts")
    public suspend fun sapMonitorName(`value`: Output<String>) {
        this.sapMonitorName = value
    }

    /**
     * @param value The type of provider instance.
     */
    @JvmName("lufoejdiyafvlnew")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value A JSON string containing metadata of the provider instance.
     */
    @JvmName("iwvrsxpwdcrepbri")
    public suspend fun metadata(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value A JSON string containing the properties of the provider instance.
     */
    @JvmName("rwdkylelnjifmxyg")
    public suspend fun properties(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Name of the provider instance.
     */
    @JvmName("tarpikyjcheftqrm")
    public suspend fun providerInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerInstanceName = mapped
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("xxajgkojayisugsd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SAP monitor resource.
     */
    @JvmName("iejlogfxvqisdkmb")
    public suspend fun sapMonitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapMonitorName = mapped
    }

    /**
     * @param value The type of provider instance.
     */
    @JvmName("dhkgjpgcwxonhuwt")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProviderInstanceArgs = ProviderInstanceArgs(
        metadata = metadata,
        properties = properties,
        providerInstanceName = providerInstanceName,
        resourceGroupName = resourceGroupName,
        sapMonitorName = sapMonitorName,
        type = type,
    )
}
