@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hanaonazure.kotlin.inputs

import com.pulumi.azurenative.hanaonazure.inputs.GetProviderInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property providerInstanceName Name of the provider instance.
 * @property resourceGroupName Name of the resource group.
 * @property sapMonitorName Name of the SAP monitor resource.
 */
public data class GetProviderInstancePlainArgs(
    public val providerInstanceName: String,
    public val resourceGroupName: String,
    public val sapMonitorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.hanaonazure.inputs.GetProviderInstancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.hanaonazure.inputs.GetProviderInstancePlainArgs =
        com.pulumi.azurenative.hanaonazure.inputs.GetProviderInstancePlainArgs.builder()
            .providerInstanceName(providerInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sapMonitorName(sapMonitorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProviderInstancePlainArgs].
 */
@PulumiTagMarker
public class GetProviderInstancePlainArgsBuilder internal constructor() {
    private var providerInstanceName: String? = null

    private var resourceGroupName: String? = null

    private var sapMonitorName: String? = null

    /**
     * @param value Name of the provider instance.
     */
    @JvmName("ctgourrfbothhbqt")
    public suspend fun providerInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerInstanceName = mapped
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("usujykklnfimnsnp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SAP monitor resource.
     */
    @JvmName("aoqelulhtaukfgjo")
    public suspend fun sapMonitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapMonitorName = mapped
    }

    internal fun build(): GetProviderInstancePlainArgs = GetProviderInstancePlainArgs(
        providerInstanceName = providerInstanceName ?: throw
            PulumiNullFieldException("providerInstanceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sapMonitorName = sapMonitorName ?: throw PulumiNullFieldException("sapMonitorName"),
    )
}
