@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hanaonazure.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A provider instance associated with a SAP monitor.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property metadata A JSON string containing metadata of the provider instance.
 * @property name The name of the resource
 * @property properties A JSON string containing the properties of the provider instance.
 * @property provisioningState State of provisioning of the provider instance
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetProviderInstanceResult(
    public val id: String,
    public val metadata: String? = null,
    public val name: String,
    public val properties: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.hanaonazure.outputs.GetProviderInstanceResult):
            GetProviderInstanceResult = GetProviderInstanceResult(
            id = javaType.id(),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
