@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hanaonazure.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * SAP monitor info on Azure (ARM properties and SAP monitor properties)
 * @property enableCustomerAnalytics The value indicating whether to send analytics to Microsoft
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property logAnalyticsWorkspaceArmId The ARM ID of the Log Analytics Workspace that is used for monitoring
 * @property logAnalyticsWorkspaceId The workspace ID of the log analytics workspace to be used for monitoring
 * @property logAnalyticsWorkspaceSharedKey The shared key of the log analytics workspace that is used for monitoring
 * @property managedResourceGroupName The name of the resource group the SAP Monitor resources get deployed into.
 * @property monitorSubnet The subnet which the SAP monitor will be deployed in
 * @property name The name of the resource
 * @property provisioningState State of provisioning of the HanaInstance
 * @property sapMonitorCollectorVersion The version of the payload running in the Collector VM
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSapMonitorResult(
    public val enableCustomerAnalytics: Boolean? = null,
    public val id: String,
    public val location: String,
    public val logAnalyticsWorkspaceArmId: String? = null,
    public val logAnalyticsWorkspaceId: String? = null,
    public val logAnalyticsWorkspaceSharedKey: String? = null,
    public val managedResourceGroupName: String,
    public val monitorSubnet: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val sapMonitorCollectorVersion: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hanaonazure.outputs.GetSapMonitorResult):
            GetSapMonitorResult = GetSapMonitorResult(
            enableCustomerAnalytics = javaType.enableCustomerAnalytics().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            logAnalyticsWorkspaceArmId = javaType.logAnalyticsWorkspaceArmId().map({ args0 ->
                args0
            }).orElse(null),
            logAnalyticsWorkspaceId = javaType.logAnalyticsWorkspaceId().map({ args0 -> args0 }).orElse(null),
            logAnalyticsWorkspaceSharedKey = javaType.logAnalyticsWorkspaceSharedKey().map({ args0 ->
                args0
            }).orElse(null),
            managedResourceGroupName = javaType.managedResourceGroupName(),
            monitorSubnet = javaType.monitorSubnet().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sapMonitorCollectorVersion = javaType.sapMonitorCollectorVersion(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
