@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin

import com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsmArgs.builder
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.NetworkProfileArgs
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.NetworkProfileArgsBuilder
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource information with extended details.
 * Azure REST API version: 2021-11-30. Prior API version in Azure Native 1.x: 2018-10-31-preview.
 * ## Example Usage
 * ### Create a new or update an existing dedicated HSM
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedHsm = new AzureNative.HardwareSecurityModules.DedicatedHsm("dedicatedHsm", new()
 *     {
 *         Location = "westus",
 *         Name = "hsm1",
 *         NetworkProfile = new AzureNative.HardwareSecurityModules.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.HardwareSecurityModules.Inputs.NetworkInterfaceArgs
 *                 {
 *                     PrivateIpAddress = "1.0.0.1",
 *                 },
 *             },
 *             Subnet = new AzureNative.HardwareSecurityModules.Inputs.ApiEntityReferenceArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01",
 *             },
 *         },
 *         ResourceGroupName = "hsm-group",
 *         Sku = new AzureNative.HardwareSecurityModules.Inputs.SkuArgs
 *         {
 *             Name = "SafeNet Luna Network HSM A790",
 *         },
 *         StampId = "stamp01",
 *         Tags =
 *         {
 *             { "Dept", "hsm" },
 *             { "Environment", "dogfood" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hardwaresecuritymodules/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hardwaresecuritymodules.NewDedicatedHsm(ctx, "dedicatedHsm", &hardwaresecuritymodules.DedicatedHsmArgs{
 * 			Location: pulumi.String("westus"),
 * 			Name:     pulumi.String("hsm1"),
 * 			NetworkProfile: hardwaresecuritymodules.NetworkProfileResponse{
 * 				NetworkInterfaces: hardwaresecuritymodules.NetworkInterfaceArray{
 * 					&hardwaresecuritymodules.NetworkInterfaceArgs{
 * 						PrivateIpAddress: pulumi.String("1.0.0.1"),
 * 					},
 * 				},
 * 				Subnet: &hardwaresecuritymodules.ApiEntityReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("hsm-group"),
 * 			Sku: &hardwaresecuritymodules.SkuArgs{
 * 				Name: pulumi.String("SafeNet Luna Network HSM A790"),
 * 			},
 * 			StampId: pulumi.String("stamp01"),
 * 			Tags: pulumi.StringMap{
 * 				"Dept":        pulumi.String("hsm"),
 * 				"Environment": pulumi.String("dogfood"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsm;
 * import com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsmArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedHsm = new DedicatedHsm("dedicatedHsm", DedicatedHsmArgs.builder()
 *             .location("westus")
 *             .name("hsm1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("networkInterfaces", Map.of("privateIpAddress", "1.0.0.1")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01"))
 *             ))
 *             .resourceGroupName("hsm-group")
 *             .sku(Map.of("name", "SafeNet Luna Network HSM A790"))
 *             .stampId("stamp01")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Dept", "hsm"),
 *                 Map.entry("Environment", "dogfood")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new or update an existing payment HSM
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedHsm = new AzureNative.HardwareSecurityModules.DedicatedHsm("dedicatedHsm", new()
 *     {
 *         Location = "westus",
 *         Name = "hsm1",
 *         NetworkProfile = new AzureNative.HardwareSecurityModules.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.HardwareSecurityModules.Inputs.NetworkInterfaceArgs
 *                 {
 *                     PrivateIpAddress = "1.0.0.1",
 *                 },
 *             },
 *             Subnet = new AzureNative.HardwareSecurityModules.Inputs.ApiEntityReferenceArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01",
 *             },
 *         },
 *         ResourceGroupName = "hsm-group",
 *         Sku = new AzureNative.HardwareSecurityModules.Inputs.SkuArgs
 *         {
 *             Name = "payShield10K_LMK1_CPS60",
 *         },
 *         StampId = "stamp01",
 *         Tags =
 *         {
 *             { "Dept", "hsm" },
 *             { "Environment", "dogfood" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hardwaresecuritymodules/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hardwaresecuritymodules.NewDedicatedHsm(ctx, "dedicatedHsm", &hardwaresecuritymodules.DedicatedHsmArgs{
 * 			Location: pulumi.String("westus"),
 * 			Name:     pulumi.String("hsm1"),
 * 			NetworkProfile: hardwaresecuritymodules.NetworkProfileResponse{
 * 				NetworkInterfaces: hardwaresecuritymodules.NetworkInterfaceArray{
 * 					&hardwaresecuritymodules.NetworkInterfaceArgs{
 * 						PrivateIpAddress: pulumi.String("1.0.0.1"),
 * 					},
 * 				},
 * 				Subnet: &hardwaresecuritymodules.ApiEntityReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("hsm-group"),
 * 			Sku: &hardwaresecuritymodules.SkuArgs{
 * 				Name: pulumi.String("payShield10K_LMK1_CPS60"),
 * 			},
 * 			StampId: pulumi.String("stamp01"),
 * 			Tags: pulumi.StringMap{
 * 				"Dept":        pulumi.String("hsm"),
 * 				"Environment": pulumi.String("dogfood"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsm;
 * import com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsmArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedHsm = new DedicatedHsm("dedicatedHsm", DedicatedHsmArgs.builder()
 *             .location("westus")
 *             .name("hsm1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("networkInterfaces", Map.of("privateIpAddress", "1.0.0.1")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01"))
 *             ))
 *             .resourceGroupName("hsm-group")
 *             .sku(Map.of("name", "payShield10K_LMK1_CPS60"))
 *             .stampId("stamp01")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Dept", "hsm"),
 *                 Map.entry("Environment", "dogfood")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new or update an existing payment HSM with management profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedHsm = new AzureNative.HardwareSecurityModules.DedicatedHsm("dedicatedHsm", new()
 *     {
 *         Location = "westus",
 *         ManagementNetworkProfile = new AzureNative.HardwareSecurityModules.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.HardwareSecurityModules.Inputs.NetworkInterfaceArgs
 *                 {
 *                     PrivateIpAddress = "1.0.0.2",
 *                 },
 *             },
 *             Subnet = new AzureNative.HardwareSecurityModules.Inputs.ApiEntityReferenceArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01",
 *             },
 *         },
 *         Name = "hsm1",
 *         NetworkProfile = new AzureNative.HardwareSecurityModules.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.HardwareSecurityModules.Inputs.NetworkInterfaceArgs
 *                 {
 *                     PrivateIpAddress = "1.0.0.1",
 *                 },
 *             },
 *             Subnet = new AzureNative.HardwareSecurityModules.Inputs.ApiEntityReferenceArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01",
 *             },
 *         },
 *         ResourceGroupName = "hsm-group",
 *         Sku = new AzureNative.HardwareSecurityModules.Inputs.SkuArgs
 *         {
 *             Name = "payShield10K_LMK1_CPS60",
 *         },
 *         StampId = "stamp01",
 *         Tags =
 *         {
 *             { "Dept", "hsm" },
 *             { "Environment", "dogfood" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hardwaresecuritymodules/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hardwaresecuritymodules.NewDedicatedHsm(ctx, "dedicatedHsm", &hardwaresecuritymodules.DedicatedHsmArgs{
 * 			Location: pulumi.String("westus"),
 * 			ManagementNetworkProfile: hardwaresecuritymodules.NetworkProfileResponse{
 * 				NetworkInterfaces: hardwaresecuritymodules.NetworkInterfaceArray{
 * 					&hardwaresecuritymodules.NetworkInterfaceArgs{
 * 						PrivateIpAddress: pulumi.String("1.0.0.2"),
 * 					},
 * 				},
 * 				Subnet: &hardwaresecuritymodules.ApiEntityReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01"),
 * 				},
 * 			},
 * 			Name: pulumi.String("hsm1"),
 * 			NetworkProfile: hardwaresecuritymodules.NetworkProfileResponse{
 * 				NetworkInterfaces: hardwaresecuritymodules.NetworkInterfaceArray{
 * 					&hardwaresecuritymodules.NetworkInterfaceArgs{
 * 						PrivateIpAddress: pulumi.String("1.0.0.1"),
 * 					},
 * 				},
 * 				Subnet: &hardwaresecuritymodules.ApiEntityReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("hsm-group"),
 * 			Sku: &hardwaresecuritymodules.SkuArgs{
 * 				Name: pulumi.String("payShield10K_LMK1_CPS60"),
 * 			},
 * 			StampId: pulumi.String("stamp01"),
 * 			Tags: pulumi.StringMap{
 * 				"Dept":        pulumi.String("hsm"),
 * 				"Environment": pulumi.String("dogfood"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsm;
 * import com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsmArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedHsm = new DedicatedHsm("dedicatedHsm", DedicatedHsmArgs.builder()
 *             .location("westus")
 *             .managementNetworkProfile(Map.ofEntries(
 *                 Map.entry("networkInterfaces", Map.of("privateIpAddress", "1.0.0.2")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01"))
 *             ))
 *             .name("hsm1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("networkInterfaces", Map.of("privateIpAddress", "1.0.0.1")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01"))
 *             ))
 *             .resourceGroupName("hsm-group")
 *             .sku(Map.of("name", "payShield10K_LMK1_CPS60"))
 *             .stampId("stamp01")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Dept", "hsm"),
 *                 Map.entry("Environment", "dogfood")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hardwaresecuritymodules:DedicatedHsm hsm1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/dedicatedHSMs/{name}
 * ```
 * @property location The supported Azure location where the dedicated HSM should be created.
 * @property managementNetworkProfile Specifies the management network interfaces of the dedicated hsm.
 * @property name Name of the dedicated Hsm
 * @property networkProfile Specifies the network interfaces of the dedicated hsm.
 * @property resourceGroupName The name of the Resource Group to which the resource belongs.
 * @property sku SKU details
 * @property stampId This field will be used when RP does not support Availability zones.
 * @property tags Resource tags
 * @property zones The Dedicated Hsm zones.
 */
public data class DedicatedHsmArgs(
    public val location: Output<String>? = null,
    public val managementNetworkProfile: Output<NetworkProfileArgs>? = null,
    public val name: Output<String>? = null,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val stampId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsmArgs> {
    override fun toJava(): com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsmArgs =
        com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsmArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .managementNetworkProfile(
                managementNetworkProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stampId(stampId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DedicatedHsmArgs].
 */
@PulumiTagMarker
public class DedicatedHsmArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var managementNetworkProfile: Output<NetworkProfileArgs>? = null

    private var name: Output<String>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var stampId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value The supported Azure location where the dedicated HSM should be created.
     */
    @JvmName("lxgsgrwsgsybxtrp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Specifies the management network interfaces of the dedicated hsm.
     */
    @JvmName("vpprxrarjwspoksv")
    public suspend fun managementNetworkProfile(`value`: Output<NetworkProfileArgs>) {
        this.managementNetworkProfile = value
    }

    /**
     * @param value Name of the dedicated Hsm
     */
    @JvmName("wflkocvwwdtfrwof")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the network interfaces of the dedicated hsm.
     */
    @JvmName("jjrbgwbeywtaavle")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value The name of the Resource Group to which the resource belongs.
     */
    @JvmName("cwdgssxdibkycwhk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SKU details
     */
    @JvmName("xvvtcsfguoncvvjn")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value This field will be used when RP does not support Availability zones.
     */
    @JvmName("mjibryfxqsvwfvnb")
    public suspend fun stampId(`value`: Output<String>) {
        this.stampId = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("rxepiomrkocpsdnq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Dedicated Hsm zones.
     */
    @JvmName("glyduucgrhhabxti")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("cajqmvnuvqwxlole")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values The Dedicated Hsm zones.
     */
    @JvmName("mnhbosxknyhxcjnb")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value The supported Azure location where the dedicated HSM should be created.
     */
    @JvmName("yxyjilxuegrupsyv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Specifies the management network interfaces of the dedicated hsm.
     */
    @JvmName("gkjdvykpmoclujsp")
    public suspend fun managementNetworkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementNetworkProfile = mapped
    }

    /**
     * @param argument Specifies the management network interfaces of the dedicated hsm.
     */
    @JvmName("uubehhttnhjhrydg")
    public suspend
    fun managementNetworkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managementNetworkProfile = mapped
    }

    /**
     * @param value Name of the dedicated Hsm
     */
    @JvmName("lfsojwxymqwbkmkh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the network interfaces of the dedicated hsm.
     */
    @JvmName("cdhpgwqvpypvyjao")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument Specifies the network interfaces of the dedicated hsm.
     */
    @JvmName("ysltkbmsibanyhdq")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value The name of the Resource Group to which the resource belongs.
     */
    @JvmName("rspsvlbqwfpooiyh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SKU details
     */
    @JvmName("axfhmplabbyrdbrp")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument SKU details
     */
    @JvmName("dwchxvayiqdfsulg")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value This field will be used when RP does not support Availability zones.
     */
    @JvmName("ftoobbsgywgikdid")
    public suspend fun stampId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stampId = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("bgfdyujgickyrsjq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("dusvfncinilexeam")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Dedicated Hsm zones.
     */
    @JvmName("hcqqbhnipwmuxylk")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values The Dedicated Hsm zones.
     */
    @JvmName("purudorisioawtyd")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): DedicatedHsmArgs = DedicatedHsmArgs(
        location = location,
        managementNetworkProfile = managementNetworkProfile,
        name = name,
        networkProfile = networkProfile,
        resourceGroupName = resourceGroupName,
        sku = sku,
        stampId = stampId,
        tags = tags,
        zones = zones,
    )
}
